"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FlatTableRowDraggable = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactDnd = require("react-dnd");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const FlatTableRowDraggable = ({
  children,
  id,
  findItem,
  moveItem,
  rowRef
}) => {
  const originalIndex = Number(findItem?.(id).index);
  const [{
    isDragging
  }, drag] = (0, _reactDnd.useDrag)({
    type: "flatTableRow",
    item: {
      id,
      originalIndex
    },
    collect: monitor => ({
      isDragging: monitor.isDragging()
    }),
    end: (dropResult, monitor) => {
      const {
        id: droppedId,
        originalIndex: oIndex
      } = monitor.getItem();
      const didDrop = monitor.didDrop();
      if (!didDrop) {
        moveItem?.(droppedId, Number(oIndex));
      }
    }
  });
  const [, drop] = (0, _reactDnd.useDrop)({
    accept: "flatTableRow",
    canDrop: () => false,
    hover(item) {
      if (item?.id !== id && findItem) {
        const {
          index: overIndex
        } = findItem(id);
        moveItem?.(item?.id, Number(overIndex));
      }
    }
  });
  return /*#__PURE__*/_react.default.cloneElement(children, {
    key: originalIndex,
    id,
    isDragging,
    ref: node => {
      drag(drop(node));
      /* istanbul ignore else */
      if (rowRef) {
        if (typeof rowRef === "function") {
          rowRef(node);
        } else {
          rowRef.current = node;
        }
      }
    }
  });
};
exports.FlatTableRowDraggable = FlatTableRowDraggable;
if (process.env.NODE_ENV !== "production") {
  FlatTableRowDraggable.propTypes = {
    "children": _propTypes.default.node,
    "draggable": _propTypes.default.bool,
    "findItem": _propTypes.default.func,
    "id": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "moveItem": _propTypes.default.func,
    "rowRef": _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.shape({
      "current": _propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.object]).isRequired
    })])
  };
}
FlatTableRowDraggable.displayName = "FlatTableRowDraggable";
var _default = exports.default = FlatTableRowDraggable;