import React from "react";
export interface FlatTableRowDraggableProps {
    /** Array of FlatTableRow. */
    children: React.ReactNode;
    /** ID for use in drag and drop functionality */
    id?: number | string;
    /** function to find an item in the list of draggable items */
    findItem?: (id?: number | string) => Record<string, unknown>;
    /** function to reposition an item in the list of draggable items */
    moveItem?: (id?: number | string, index?: number) => void;
    /** item is draggable */
    draggable?: boolean;
    /** ref for row element */
    rowRef?: React.ForwardedRef<HTMLTableRowElement | null>;
}
export declare const FlatTableRowDraggable: {
    ({ children, id, findItem, moveItem, rowRef, }: FlatTableRowDraggableProps): React.ReactElement<any, string | React.JSXElementConstructor<any>>;
    displayName: string;
};
export default FlatTableRowDraggable;
