"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledFlatTableRowHeaderContent = exports.StyledFlatTableRowHeader = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../../style/themes/base"));
var _color = require("../../../style/utils/color");
var _icon = _interopRequireDefault(require("../../icon/icon.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const verticalBorderSizes = {
  small: "1px",
  medium: "2px",
  large: "4px"
};
const StyledFlatTableRowHeader = exports.StyledFlatTableRowHeader = _styledComponents.default.th.attrs(({
  stickyAlignment
}) => ({
  "data-sticky-align": stickyAlignment
}))`
  ${({
  align,
  theme,
  width,
  leftPosition,
  rightPosition,
  truncate,
  expandable,
  verticalBorder,
  verticalBorderColor,
  stickyAlignment
}) => (0, _styledComponents.css)`
    background-color: var(--colorsUtilityYang100);
    border: 1px solid var(--colorsUtilityMajor100);
    border-top: none;
    box-sizing: border-box;
    left: 0;
    font-weight: normal;
    position: sticky;
    text-align: ${align};
    top: auto;
    vertical-align: middle;
    padding: 0;
    z-index: ${_base.default.zIndex.overlay};

    ${width && (0, _styledComponents.css)`
      width: ${width}px;
    `}

    &&&& {
      > div {
        box-sizing: border-box;

        ${truncate && (0, _styledComponents.css)`
          text-overflow: ellipsis;
          overflow: hidden;
          white-space: nowrap;
        `}

        ${width && (0, _styledComponents.css)`
          width: ${width}px;
        `}
 
        ${_styledSystem.padding}
      }

      ${leftPosition !== undefined && (0, _styledComponents.css)`
        left: ${leftPosition}px;
      `}
      ${rightPosition !== undefined && (0, _styledComponents.css)`
        right: ${rightPosition}px;
      `}

      ${verticalBorder && (0, _styledComponents.css)`
        border-${stickyAlignment === "right" ? "left" : "right"}-width: ${verticalBorderSizes[verticalBorder]};
      `}

      ${verticalBorderColor && (0, _styledComponents.css)`
        border-${stickyAlignment === "right" ? "left" : "right"}-color: ${(0, _color.toColor)(theme, verticalBorderColor)};
      `}

      [data-component="icon"]:not([color]) {
        color: var(--colorsActionMinor500);
      }
    }

    ${expandable && (0, _styledComponents.css)`
      white-space: nowrap;
    `}
  `}
`;
StyledFlatTableRowHeader.defaultProps = {
  theme: _base.default
};
const StyledFlatTableRowHeaderContent = exports.StyledFlatTableRowHeaderContent = _styledComponents.default.div`
  ${({
  expandable
}) => expandable && (0, _styledComponents.css)`
      display: flex;
      align-items: center;
      line-height: 1em;

      ${_icon.default} {
        width: 16px;
        height: 16px;
      }
    `}
`;