"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FlatTableRowHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _icon = _interopRequireDefault(require("../../icon"));
var _flatTableRowHeader = require("./flat-table-row-header.style");
var _guid = _interopRequireDefault(require("../../../__internal__/utils/helpers/guid"));
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags/tags"));
var _useTableCell = _interopRequireDefault(require("../__internal__/use-table-cell"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const FlatTableRowHeader = ({
  align = "left",
  children,
  width,
  py,
  px,
  truncate,
  title,
  stickyAlignment = "left",
  colspan,
  rowspan,
  id,
  ...rest
}) => {
  const internalId = (0, _react.useRef)(id || (0, _guid.default)());
  const {
    leftPosition,
    rightPosition,
    expandable,
    onClick,
    onKeyDown,
    isFirstCell,
    isExpandableCell,
    tabIndex,
    isInHighlightedRow,
    isInSelectedRow
  } = (0, _useTableCell.default)(internalId.current);
  const handleOnClick = (0, _react.useCallback)(ev => {
    if (isExpandableCell && onClick) onClick(ev);
  }, [isExpandableCell, onClick]);
  const handleOnKeyDown = (0, _react.useCallback)(ev => {
    if (isExpandableCell && onKeyDown) {
      onKeyDown(ev);
    }
  }, [isExpandableCell, onKeyDown]);
  return /*#__PURE__*/_react.default.createElement(_flatTableRowHeader.StyledFlatTableRowHeader, _extends({
    leftPosition: stickyAlignment === "left" ? leftPosition || 0 : undefined,
    rightPosition: stickyAlignment === "right" ? rightPosition || 0 : undefined,
    align: align
  }, (0, _tags.default)("flat-table-row-header", {
    "data-element": "flat-table-row-header",
    ...rest
  }), {
    width: width,
    py: py || "10px",
    px: px || 3,
    onClick: handleOnClick,
    tabIndex: isExpandableCell ? tabIndex : undefined,
    onKeyDown: handleOnKeyDown,
    truncate: truncate,
    expandable: expandable,
    stickyAlignment: stickyAlignment
  }, colspan !== undefined && {
    colSpan: Number(colspan)
  }, rowspan !== undefined && {
    rowSpan: Number(rowspan)
  }, {
    "data-selected": isInSelectedRow && isExpandableCell,
    "data-highlighted": isInHighlightedRow && isExpandableCell
  }, rest, {
    id: internalId.current
  }), /*#__PURE__*/_react.default.createElement(_flatTableRowHeader.StyledFlatTableRowHeaderContent, {
    title: truncate && !title && typeof children === "string" ? children : title,
    expandable: expandable
  }, expandable && isFirstCell && /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "chevron_down_thick",
    mr: "8px"
  }), children));
};
exports.FlatTableRowHeader = FlatTableRowHeader;
FlatTableRowHeader.displayName = "FlatTableRowHeader";
var _default = exports.default = FlatTableRowHeader;