import React from "react";
import { PaddingProps } from "styled-system";
import { TableBorderSize, TableCellAlign } from "..";
import { TagProps } from "../../../__internal__/utils/helpers/tags/tags";
export interface FlatTableRowHeaderProps extends PaddingProps, TagProps {
    /** Content alignment */
    align?: TableCellAlign;
    /** RowHeader content */
    children?: React.ReactNode;
    /** Column width, pass a number to set a fixed width in pixels */
    width?: number;
    /** Truncate cell content and add ellipsis to any text that overflows */
    truncate?: boolean;
    /** Title text to display if cell content truncates */
    title?: string;
    /** Sets a custom vertical right border */
    verticalBorder?: TableBorderSize;
    /** Sets the color of the right border */
    verticalBorderColor?: string;
    /** Defines whether the column should be sticky on the left or right hand side of the Table */
    stickyAlignment?: "left" | "right";
    /** Number of columns that a header cell should span */
    colspan?: number | string;
    /** Number of rows that a header cell should span */
    rowspan?: number | string;
    /** Sets an id string on the element */
    id?: string;
}
export declare const FlatTableRowHeader: {
    ({ align, children, width, py, px, truncate, title, stickyAlignment, colspan, rowspan, id, ...rest }: FlatTableRowHeaderProps): React.JSX.Element;
    displayName: string;
};
export default FlatTableRowHeader;
