"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _flatTableHeaderUtils = _interopRequireDefault(require("./flat-table-header-utils"));
var _base = _interopRequireDefault(require("../../../style/themes/base"));
var _color = require("../../../style/utils/color");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const verticalBorderSizes = {
  small: "1px",
  medium: "2px",
  large: "4px"
};
const StyledFlatTableHeader = _styledComponents.default.th`
  ${({
  align,
  alternativeBgColor,
  colWidth,
  leftPosition,
  rightPosition,
  makeCellSticky,
  verticalBorder,
  verticalBorderColor,
  colorTheme,
  theme
}) => (0, _styledComponents.css)`
    background-color: transparent;
    border-width: 0;
    box-sizing: border-box;
    font-weight: 700;
    left: auto;
    text-align: ${align};
    user-select: none;
    vertical-align: middle;
    white-space: nowrap;
    word-break: keep-all;
    padding: 0;
    ${colWidth && (0, _styledComponents.css)`
        width: ${colWidth}px;
      `}

    /* accommodate for no border in the header first cell */
    &:first-child {
      padding-left: 1px;
    }

    &&& {
      > div {
        box-sizing: border-box;
        ${_styledSystem.padding}

        ${colWidth && (0, _styledComponents.css)`
            width: ${colWidth}px;
          `}
      }
    }

    ${alternativeBgColor && (0, _styledComponents.css)`
        &&& {
          background-color: ${(0, _flatTableHeaderUtils.default)(colorTheme)};
        }
        &&&:first-child {
          border-left: unset;
        }
      `};

    ${makeCellSticky && (0, _styledComponents.css)`
        ${leftPosition !== undefined && `left: ${leftPosition}px;`}
        ${rightPosition !== undefined && `right: ${rightPosition}px;`}
        position: sticky;
       
        &:first-child {
          padding-right: 0.395em;

          /* Applies specific styling for Firefox. Increased padding is required to ensure no gap is present between
          the th elements. This includes FlatTableHeader and FlatTableRowHeader */
          @-moz-document url-prefix() {
            padding-right: 2px;
          }

          /* Styling for safari. Increased padding is required to ensure no gap is present between
          the th elements. This includes FlatTableHeader and FlatTableRowHeader  */
          @media not all and (min-resolution:.001dpcm) {
            @supports (-webkit-appearance:none) and (stroke-color:transparent) {
              padding-right: 0.9em;
            }
          }
      `}

    &&& {
      ${verticalBorder && (0, _styledComponents.css)`
          border-right-width: ${verticalBorderSizes[verticalBorder]};
        `}

      ${verticalBorderColor && (0, _styledComponents.css)`
          border-right-color: ${(0, _color.toColor)(theme, verticalBorderColor)};
        `}
      }
    }
  `}
`;
StyledFlatTableHeader.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledFlatTableHeader;