import React from "react";
import { PaddingProps } from "styled-system";
import { TableBorderSize, TableCellAlign } from "..";
export interface FlatTableHeaderProps extends PaddingProps {
    /** Content alignment */
    align?: TableCellAlign;
    /** If true sets alternative background color */
    alternativeBgColor?: boolean;
    /** Header content */
    children?: React.ReactNode;
    /** Number of columns that a header cell should span */
    colspan?: number | string;
    /** Number of rows that a header cell should span */
    rowspan?: number | string;
    /** Sets a custom vertical right border */
    verticalBorder?: TableBorderSize;
    /** Sets the color of the right border */
    verticalBorderColor?: string;
    /** Column width, pass a number to set a fixed width in pixels */
    width?: number;
    /** Sets an id string on the element */
    id?: string;
}
export declare const FlatTableHeader: {
    ({ align, children, colspan, rowspan, width, py, px, id, ...rest }: FlatTableHeaderProps): React.JSX.Element;
    displayName: string;
};
export default FlatTableHeader;
