"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FlatTableHeadContext = exports.FlatTableHead = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _flatTableHead = _interopRequireDefault(require("./flat-table-head.style"));
var _internal__ = require("../__internal__");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const FlatTableHeadContext = exports.FlatTableHeadContext = /*#__PURE__*/_react.default.createContext({
  stickyOffsets: {}
});
const FlatTableHead = ({
  children,
  ...rest
}) => {
  const ref = (0, _react.useRef)(null);
  const [stickyOffsets, setStickyOffsets] = (0, _react.useState)({});
  (0, _react.useEffect)(() => {
    const headerRows = ref.current?.querySelectorAll("tr");

    /* istanbul ignore else */
    if (headerRows) {
      setStickyOffsets((0, _internal__.buildPositionMap)(Array.from(headerRows), "offsetHeight"));
    } else {
      setStickyOffsets({});
    }
  }, [children]);
  return /*#__PURE__*/_react.default.createElement(_flatTableHead.default, _extends({
    ref: ref
  }, rest), /*#__PURE__*/_react.default.createElement(FlatTableHeadContext.Provider, {
    value: {
      stickyOffsets
    }
  }, children));
};
exports.FlatTableHead = FlatTableHead;
var _default = exports.default = FlatTableHead;