"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FlatTableCheckbox = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _flatTableCheckbox = _interopRequireDefault(require("./flat-table-checkbox.style"));
var _checkbox = require("../../checkbox");
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events/events"));
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags"));
var _guid = _interopRequireDefault(require("../../../__internal__/utils/helpers/guid"));
var _flatTableRowContext = _interopRequireDefault(require("../flat-table-row/__internal__/flat-table-row-context"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const FlatTableCheckbox = ({
  as = "td",
  checked,
  onChange,
  selectable = true,
  onClick,
  ariaLabelledBy,
  id,
  ...rest
}) => {
  const ref = (0, _react.useRef)(null);
  const internalId = (0, _react.useRef)(id || (0, _guid.default)());
  const {
    leftPositions,
    rightPositions
  } = (0, _react.useContext)(_flatTableRowContext.default);
  const leftPosition = leftPositions[internalId.current];
  const rightPosition = rightPositions[internalId.current];
  const makeCellSticky = leftPosition !== undefined || rightPosition !== undefined;
  const dataElement = `flat-table-checkbox-${as === "td" ? "cell" : "header"}`;
  const handleClick = event => {
    event.stopPropagation();
    if (onClick) onClick(event);
  };
  const handleKeyDown = event => {
    if (!_events.default.isDownKey(event) && !_events.default.isUpKey(event)) {
      event.stopPropagation();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_flatTableCheckbox.default, _extends({
    ref: ref,
    makeCellSticky: makeCellSticky,
    className: makeCellSticky ? "isSticky" : undefined,
    leftPosition: leftPosition,
    rightPosition: rightPosition,
    as: as
  }, (0, _tags.default)("flat-table-checkbox", {
    "data-element": dataElement,
    ...rest
  }), {
    id: internalId.current
  }), selectable && /*#__PURE__*/_react.default.createElement(_checkbox.Checkbox, {
    checked: checked,
    onChange: onChange,
    name: "flat-table-checkbox",
    mb: 0,
    ariaLabelledBy: ariaLabelledBy,
    onClick: handleClick,
    onKeyDown: handleKeyDown
  }));
};
exports.FlatTableCheckbox = FlatTableCheckbox;
FlatTableCheckbox.displayName = "FlatTableCheckbox";
var _default = exports.default = FlatTableCheckbox;