"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledFlatTableCell = exports.StyledCellContent = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../../style/themes/base"));
var _color = require("../../../style/utils/color");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const verticalBorderSizes = {
  small: "1px",
  medium: "2px",
  large: "4px"
};
const StyledFlatTableCell = exports.StyledFlatTableCell = _styledComponents.default.td`
  ${({
  align,
  theme,
  rowSpan,
  leftPosition,
  rightPosition,
  makeCellSticky,
  colWidth,
  isTruncated,
  expandable,
  verticalBorder,
  verticalBorderColor
}) => (0, _styledComponents.css)`
    background-color: var(--colorsUtilityYang100);
    border-width: 0;
    border-bottom: 1px solid var(--colorsUtilityMajor100);
    text-align: ${align};
    vertical-align: middle;
    padding: 0;

    ${colWidth && (0, _styledComponents.css)`
      width: ${colWidth}px;
    `}

    &&&& {
      > div {
        box-sizing: border-box;

        ${isTruncated && (0, _styledComponents.css)`
          text-overflow: ellipsis;
          overflow: hidden;
          white-space: nowrap;
        `}

        ${colWidth && (0, _styledComponents.css)`
          width: ${colWidth}px;
        `}
 
        ${_styledSystem.padding}
      }

      ${verticalBorder && (0, _styledComponents.css)`
        border-right: ${verticalBorderSizes[verticalBorder]} solid
          var(--colorsUtilityMajor300);
      `}

      ${verticalBorderColor && (0, _styledComponents.css)`
        border-right-color: ${(0, _color.toColor)(theme, verticalBorderColor)};
      `}

      [data-component="icon"]:not([color]) {
        color: var(--colorsActionMinor500);
      }
    }

    &:first-of-type {
      border-left: 1px solid var(--colorsUtilityMajor100);
    }

    &:last-of-type {
      border-right: 1px solid var(--colorsUtilityMajor100);
    }

    ${rowSpan && (0, _styledComponents.css)`
      &:first-of-type + & {
        border-left: 1px solid var(--colorsUtilityMajor100);
      }
    `}

    ${makeCellSticky && (0, _styledComponents.css)`
      ${leftPosition !== undefined && `left: ${leftPosition}px;`}
      ${rightPosition !== undefined && `right: ${rightPosition}px;`}
      position: sticky;
    `}

    ${expandable && (0, _styledComponents.css)`
      white-space: nowrap;
    `}
  `}
`;
const StyledCellContent = exports.StyledCellContent = _styledComponents.default.div`
  ${({
  expandable
}) => expandable && (0, _styledComponents.css)`
      display: flex;
      align-items: center;
      line-height: 1em;
    `}
`;
StyledFlatTableCell.defaultProps = {
  theme: _base.default
};