"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FlatTableCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _flatTableCell = require("./flat-table-cell.style");
var _icon = _interopRequireDefault(require("../../icon"));
var _guid = _interopRequireDefault(require("../../../__internal__/utils/helpers/guid"));
var _useTableCell = _interopRequireDefault(require("../__internal__/use-table-cell"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const FlatTableCell = ({
  align = "left",
  children,
  pl,
  width,
  truncate = false,
  title,
  colspan,
  rowspan,
  id,
  ...rest
}) => {
  const internalId = (0, _react.useRef)(id || (0, _guid.default)());
  const {
    leftPosition,
    rightPosition,
    expandable,
    onClick,
    onKeyDown,
    isFirstCell,
    isExpandableCell,
    makeCellSticky,
    isInHighlightedRow,
    isInSelectedRow,
    tabIndex
  } = (0, _useTableCell.default)(internalId.current);
  return /*#__PURE__*/_react.default.createElement(_flatTableCell.StyledFlatTableCell, _extends({
    leftPosition: leftPosition,
    rightPosition: rightPosition,
    makeCellSticky: makeCellSticky,
    className: makeCellSticky ? "isSticky" : undefined,
    align: align,
    "data-element": "flat-table-cell",
    pl: pl,
    onClick: isExpandableCell ? onClick : undefined,
    tabIndex: isExpandableCell ? tabIndex : undefined,
    onKeyDown: isExpandableCell ? onKeyDown : undefined,
    colWidth: width,
    isTruncated: truncate,
    expandable: expandable
  }, colspan !== undefined && {
    colSpan: Number(colspan)
  }, rowspan !== undefined && {
    rowSpan: Number(rowspan)
  }, {
    "data-selected": isInSelectedRow && isExpandableCell,
    "data-highlighted": isInHighlightedRow && isExpandableCell
  }, rest, {
    id: internalId.current
  }), /*#__PURE__*/_react.default.createElement(_flatTableCell.StyledCellContent, {
    title: truncate && !title && typeof children === "string" ? children : title,
    expandable: expandable
  }, expandable && isFirstCell && /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "chevron_down_thick",
    mr: "8px"
  }), children));
};
exports.FlatTableCell = FlatTableCell;
FlatTableCell.displayName = "FlatTableCell";
var _default = exports.default = FlatTableCell;