"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FlatTableBodyDraggable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactDnd = require("react-dnd");
var _reactDndHtml5Backend = require("react-dnd-html5-backend");
var _icon = _interopRequireDefault(require("../../icon/icon.style"));
var _flatTableBodyDraggable = _interopRequireDefault(require("./flat-table-body-draggable.style"));
var _flatTableCell = _interopRequireDefault(require("../flat-table-cell/flat-table-cell.component"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const DropTarget = ({
  children,
  getOrder,
  ...rest
}) => {
  const [isDragging, setIsDragging] = (0, _react.useState)(false);
  const [, drop] = (0, _reactDnd.useDrop)({
    accept: "flatTableRow",
    hover: (_, monitor) => {
      if (!isDragging && monitor.isOver()) setIsDragging(true);
    },
    drop() {
      setIsDragging(false);
      getOrder?.();
    }
  });
  return /*#__PURE__*/_react.default.createElement(_flatTableBodyDraggable.default, _extends({
    "data-role": "flat-table-body-draggable",
    ref: drop,
    isDragging: isDragging
  }, rest), children);
};
const FlatTableBodyDraggable = ({
  children,
  getOrder,
  ...rest
}) => {
  const [draggableItems, setDraggableItems] = (0, _react.useState)(_react.default.Children.toArray(children));
  const isFirstRender = (0, _react.useRef)(true);
  (0, _react.useEffect)(() => {
    if (!isFirstRender.current) {
      setDraggableItems(_react.default.Children.toArray(children));
    } else {
      isFirstRender.current = false;
    }
  }, [children]);
  const findItem = id => {
    const draggableItem = draggableItems.filter(item => /*#__PURE__*/_react.default.isValidElement(item) && `${item.props.id}` === id)[0];
    return {
      draggableItem,
      index: draggableItems.indexOf(draggableItem)
    };
  };
  const moveItem = (id, atIndex) => {
    const {
      draggableItem,
      index
    } = findItem(id);
    if (!draggableItem) return;
    const copyOfDraggableItems = [...draggableItems];
    copyOfDraggableItems.splice(index, 1);
    copyOfDraggableItems.splice(atIndex, 0, draggableItem);
    setDraggableItems(copyOfDraggableItems);
  };
  const getItemsId = () => {
    if (!getOrder) {
      return;
    }
    const draggableItemIds = draggableItems.map(draggableItem => /*#__PURE__*/_react.default.isValidElement(draggableItem) && draggableItem.props.id);
    getOrder(draggableItemIds);
  };
  return /*#__PURE__*/_react.default.createElement(_reactDnd.DndProvider, {
    backend: _reactDndHtml5Backend.HTML5Backend
  }, /*#__PURE__*/_react.default.createElement(DropTarget, _extends({
    getOrder: getItemsId
  }, rest), draggableItems.map(item => /*#__PURE__*/_react.default.isValidElement(item) && /*#__PURE__*/_react.default.cloneElement(item, {
    id: `${item.props.id}`,
    moveItem,
    findItem,
    draggable: true
  }, [/*#__PURE__*/_react.default.createElement(_flatTableCell.default, {
    key: item.props.id
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "drag"
  })), item.props.children]))));
};
exports.FlatTableBodyDraggable = FlatTableBodyDraggable;
var _default = exports.default = FlatTableBodyDraggable;