"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _flatTableRowContext = _interopRequireDefault(require("../flat-table-row/__internal__/flat-table-row-context"));
var _flatTable = require("../flat-table.component");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
var _default = id => {
  const {
    getTabStopElementId
  } = (0, _react.useContext)(_flatTable.FlatTableThemeContext);
  const [tabIndex, setTabIndex] = (0, _react.useState)(-1);
  const {
    expandable,
    firstCellId,
    firstColumnExpandable,
    leftPositions,
    rightPositions,
    onClick,
    onKeyDown,
    highlighted,
    selected
  } = (0, _react.useContext)(_flatTableRowContext.default);
  const leftPosition = leftPositions[id];
  const rightPosition = rightPositions[id];
  const makeCellSticky = leftPosition !== undefined || rightPosition !== undefined;
  const isFirstCell = id === firstCellId;
  const isExpandableCell = expandable && isFirstCell && firstColumnExpandable;
  (0, _react.useEffect)(() => {
    const tabstopTimer = setTimeout(() => {
      setTabIndex(isExpandableCell && getTabStopElementId() === id ? 0 : -1);
    }, 0);
    return () => {
      clearTimeout(tabstopTimer);
    };
  }, [getTabStopElementId, isExpandableCell, id]);
  return {
    expandable,
    leftPosition,
    rightPosition,
    makeCellSticky,
    onClick,
    onKeyDown,
    isFirstCell,
    isExpandableCell,
    tabIndex,
    isInHighlightedRow: highlighted,
    isInSelectedRow: selected
  };
};
exports.default = _default;