"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledHiddenFileInput = exports.StyledFileInputPresentation = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _typography = _interopRequireDefault(require("../typography/typography.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledHiddenFileInput = exports.StyledHiddenFileInput = _styledComponents.default.input`
  display: none;
`;
const StyledFileInputPresentation = exports.StyledFileInputPresentation = _styledComponents.default.div`
  ${({
  hasUploadStatus,
  minWidth,
  minHeight,
  maxWidth,
  maxHeight
}) => (0, _styledComponents.css)`
    min-width: ${minWidth};
    min-height: ${minHeight};
    max-width: ${maxWidth};
    ${!hasUploadStatus && (0, _styledComponents.css)`
      padding: 11px; /* not 12px to account for 1px border */
      max-height: ${maxHeight};
      box-sizing: border-box;
    `}
  `}

  ${({
  hasUploadStatus,
  isDraggedOver,
  isDraggingFile,
  error,
  isVertical
}) => {
  const borderWidthToken = error || isDraggingFile ? "borderWidth200" : "borderWidth100";
  let borderColorToken = "colorsUtilityMajor300";
  let backgroundColorToken = "colorsUtilityYang100";
  if (isDraggedOver) {
    borderColorToken = "colorsUtilityMajor400";
    backgroundColorToken = "colorsUtilityMajor100";
  } else if (isDraggingFile) {
    borderColorToken = "colorsUtilityMajor400";
  }
  if (error) {
    borderColorToken = `colorsSemanticNegative${isDraggingFile ? 600 : 500}`;
  }
  return !hasUploadStatus && (0, _styledComponents.css)`
        display: flex;
        ${isVertical && "flex-direction: column;"}
        flex-wrap: wrap;
        justify-content: center;
        align-content: center;
        align-items: center;
        text-align: center;
        gap: var(--spacing100);
        border-radius: var(--borderRadius050);
        border: var(--${borderWidthToken}) dashed var(--${borderColorToken});
        background: var(--${backgroundColorToken});
        ${_typography.default} {
          color: var(--colorsUtilityYin055);
        }
      `;
}}
`;