"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledFileUploadStatusRow = exports.StyledFileUploadStatus = exports.StyledFileLinkContainer = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _typography = _interopRequireDefault(require("../../../typography/typography.style"));
var _icon = _interopRequireDefault(require("../../../icon/icon.style"));
var _progressTracker = require("../../../progress-tracker/progress-tracker.style");
var _loaderBar = _interopRequireWildcard(require("../../../loader-bar/loader-bar.style"));
var _link = require("../../../link/link.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledFileLinkContainer = exports.StyledFileLinkContainer = _styledComponents.default.div`
  color: var(--colorsActionMajorYin090);
  display: flex;
  align-items: center;
  overflow-x: clip;
  overflow-y: visible;
  padding-right: var(--spacing150);

  ${_link.StyledLink} {
    overflow: hidden;
  }

  ${_link.StyledLink} a {
    overflow: hidden;
    display: flex;
    text-decoration: none;
  }

  ${_link.StyledContent} {
    overflow: hidden;
    text-overflow: ellipsis;
    text-decoration: underline;
  }

  &&& ${_icon.default} {
    display: inline-flex;
    justify-content: center;
    align-items: flex-start;
    width: 24px;
    height: 24px;

    // only apply these styles when the icon is not part of a Link component
    :not(${_link.StyledLink} ${_icon.default}) {
      color: var(--colorsUtilityYin065);
      padding-right: var(--spacing100);
    }
  }
`;
const StyledFileUploadStatusRow = exports.StyledFileUploadStatusRow = _styledComponents.default.div`
  display: flex;
  justify-content: space-between;
  ${({
  onlyRow
}) => onlyRow ? "" : "align-items: baseline;"}
  padding-left: var(--spacing150);
  ${({
  upperPadding
}) => upperPadding ? "padding-top: var(--spacing050);" : ""}
  ${({
  lowerPadding
}) => lowerPadding ? "padding-bottom: var(--spacing125);" : ""}

  ${_typography.default} {
    color: var(--colorsUtilityYin055);
  }
`;
const StyledFileUploadStatus = exports.StyledFileUploadStatus = _styledComponents.default.div`
  background-color: var(--colorsUtilityYang100);
  ${({
  hasError
}) => {
  const borderWidthToken = hasError ? "borderWidth200" : "borderWidth100";
  const colorToken = hasError ? "colorsSemanticNegative500" : "colorsUtilityMajor300";
  return (0, _styledComponents.css)`
      border: var(--${borderWidthToken}) solid var(--${colorToken});
      ${hasError && `&& ${_typography.default} {
        color: var(--${colorToken});
        font-weight: 500;
      }`}
    `;
}}
  border-radius: var(--borderRadius050);

  ${_progressTracker.StyledProgressBar}, ${_progressTracker.InnerBar} {
    border-radius: var(--borderRadius050);
    border: none;
  }

  ${_loaderBar.StyledLoader} {
    display: flex;
  }

  ${_loaderBar.default} {
    background-color: var(--colorsSemanticNeutral200);
  }

  ${_loaderBar.InnerBar} {
    background-color: var(--colorsSemanticNeutral500);
    border-radius: var(--borderRadius050);
  }
`;