"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FileUploadStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _link = _interopRequireDefault(require("../../../link"));
var _buttonMinor = _interopRequireDefault(require("../../../button-minor"));
var _typography = _interopRequireDefault(require("../../../typography/typography.style"));
var _progressTracker = _interopRequireDefault(require("../../../progress-tracker"));
var _loaderBar = _interopRequireDefault(require("../../../loader-bar"));
var _icon = _interopRequireDefault(require("../../../icon"));
var _fileUploadStatus = require("./file-upload-status.style");
var _useLocale = _interopRequireDefault(require("../../../../hooks/__internal__/useLocale"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const FileUploadStatus = ({
  status,
  filename,
  message,
  onAction,
  iconType = "file_generic",
  ...statusProps
}) => {
  const locale = (0, _useLocale.default)();
  const statusMessage = message || locale.fileInput.fileUploadStatus();
  let buttonText;
  let linkProps;
  let progressBar = null;
  switch (status) {
    case "uploading":
      buttonText = locale.fileInput.actions.cancel();
      progressBar = statusProps.progress === undefined ? /*#__PURE__*/_react.default.createElement(_loaderBar.default, null) : /*#__PURE__*/_react.default.createElement(_progressTracker.default, {
        progress: statusProps.progress,
        length: "100%"
      });
      break;
    case "previously":
    case "completed":
      buttonText = locale.fileInput.actions.delete();
      linkProps = {
        ...statusProps,
        icon: iconType
      };
      break;
    case "error":
      buttonText = locale.fileInput.actions.clear();
      break;
    // istanbul ignore next
    default:
      // no other cases if consumers are using TS, but ESLint still insists on it
      break;
  }
  const actionButton = /*#__PURE__*/_react.default.createElement(_buttonMinor.default, {
    onClick: onAction,
    buttonType: "tertiary"
  }, buttonText);
  const fileLink = linkProps ? /*#__PURE__*/_react.default.createElement(_link.default, linkProps, filename) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: iconType
  }), /*#__PURE__*/_react.default.createElement("span", null, filename));
  const mainRow = status !== "previously" ? /*#__PURE__*/_react.default.createElement(_fileUploadStatus.StyledFileUploadStatusRow, null, /*#__PURE__*/_react.default.createElement(_typography.default, {
    as: "p",
    mb: 0,
    "aria-live": "polite"
  }, statusMessage), actionButton) : /*#__PURE__*/_react.default.createElement(_fileUploadStatus.StyledFileUploadStatusRow, {
    onlyRow: true
  }, /*#__PURE__*/_react.default.createElement(_fileUploadStatus.StyledFileLinkContainer, null, fileLink), actionButton);
  const secondRow = status !== "previously" ? /*#__PURE__*/_react.default.createElement(_fileUploadStatus.StyledFileUploadStatusRow, {
    upperPadding: true,
    lowerPadding: true
  }, /*#__PURE__*/_react.default.createElement(_fileUploadStatus.StyledFileLinkContainer, null, fileLink)) : null;
  return /*#__PURE__*/_react.default.createElement(_fileUploadStatus.StyledFileUploadStatus, {
    hasError: status === "error"
  }, mainRow, secondRow, progressBar);
};
exports.FileUploadStatus = FileUploadStatus;
var _default = exports.default = FileUploadStatus;