"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledLegend = exports.FieldsetStyle = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _formField = _interopRequireDefault(require("../../__internal__/form-field/form-field.style"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _checkbox = _interopRequireDefault(require("../checkbox/checkbox.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FieldsetStyle = exports.FieldsetStyle = _styledComponents.default.fieldset`
  margin: 0;
  ${_styledSystem.margin}
  border: none;
  padding: 0;

  &&&& ${_formField.default} {
    margin-top: 0;
    margin-bottom: -1px;
  }

  & ${_checkbox.default} {
    padding-top: 8px;
    padding-bottom: 8px;
  }
`;
FieldsetStyle.defaultProps = {
  theme: _base.default
};
const StyledLegend = exports.StyledLegend = _styledComponents.default.legend`
  display: flex;
  align-items: center;
  margin-bottom: 32px;
  font-size: 20px;
  font-weight: var(--fontWeights700);
  color: var(--colorsUtilityYin090);
  line-height: 24px;
  margin-right: 4px;

  ${({
  isRequired
}) => isRequired && (0, _styledComponents.css)`
      ::after {
        content: "*";
        line-height: 24px;
        color: var(--colorsSemanticNegative500);
        font-weight: var(--fontWeights700);
        margin-left: var(--spacing100);
        position: relative;
        top: 1px;
        left: -4px;
      }
    `}

  ${({
  isOptional
}) => isOptional && (0, _styledComponents.css)`
      ::after {
        content: "(optional)";
        color: var(--colorsUtilityYin055);
        font-weight: var(--fontWeights400);
        margin-left: var(--spacing050);
      }
    `}
`;