"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Fieldset = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _fieldset = require("./fieldset.style");
var _carbonProvider = require("../carbon-provider/carbon-provider.component");
var _formSpacingProvider = _interopRequireDefault(require("../../__internal__/form-spacing-provider"));
var _useFormSpacing = _interopRequireDefault(require("../../hooks/__internal__/useFormSpacing"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Fieldset = ({
  children,
  legend,
  required,
  isOptional,
  ...rest
}) => {
  const [ref, setRef] = (0, _react.useState)(null);
  const marginProps = (0, _useFormSpacing.default)(rest);
  (0, _react.useEffect)(() => {
    if (ref && required) {
      Array.from(ref.querySelectorAll("input") || /* istanbul ignore next */[]).forEach(el => {
        el.setAttribute("required", "");
      });
    }
  }, [ref, required]);
  return /*#__PURE__*/_react.default.createElement(_carbonProvider.NewValidationContext.Provider, {
    value: {
      validationRedesignOptIn: false
    }
  }, /*#__PURE__*/_react.default.createElement(_fieldset.FieldsetStyle, _extends({
    ref: setRef
  }, (0, _tags.default)("fieldset", rest), rest, marginProps), legend && /*#__PURE__*/_react.default.createElement(_fieldset.StyledLegend, {
    "data-element": "legend",
    isRequired: required,
    isOptional: isOptional
  }, legend), /*#__PURE__*/_react.default.createElement(_formSpacingProvider.default, {
    marginBottom: undefined
  }, children)));
};
exports.Fieldset = Fieldset;
Fieldset.displayName = "Fieldset";
var _default = exports.default = Fieldset;