"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledPicklist = exports.StyledEmptyContainer = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _box = _interopRequireDefault(require("../../box/box.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
// TODO: remove polymorphism when we revisit as part of ticket FE-6177
const StyledPicklist = exports.StyledPicklist = (0, _styledComponents.default)(_box.default).attrs({
  as: "ul"
})`
  position: relative;
  list-style: none;
  margin: 0;
  padding: 8px 8px 8px 8px;
  width: 100%;
  box-sizing: border-box;
  overflow-y: auto;
  height: 400px;

  & + & {
    margin-left: 32px;
  }

  .picklist-item-enter {
    opacity: 0;
    transform: translate(-16px);
    transition: all 300ms ease-in;
  }

  .picklist-item-enter-active {
    opacity: 1;
    transform: translate(0px);
    transition: all 300ms ease-in;
  }

  .picklist-group-enter {
    opacity: 0;
    transform: translate(-16px);
    transition: all 300ms ease-in;
  }

  .picklist-group-enter-active {
    opacity: 1;
    transform: translate(0px);
    transition: all 300ms ease-in;
  }
`;
const StyledEmptyContainer = exports.StyledEmptyContainer = _styledComponents.default.li`
  position: absolute;
  top: 0;
  bottom: 0;
  left: 0;
  right: 0;
  height: 100%;
`;