"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Picklist = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactTransitionGroup = require("react-transition-group");
var _picklist = require("./picklist.style");
var _duellingPicklist = _interopRequireDefault(require("../duelling-picklist.context"));
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
var _picklistGroup = _interopRequireDefault(require("../picklist-group/picklist-group.component"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Picklist = ({
  disabled,
  children,
  placeholder,
  index
}) => {
  const {
    elementToFocus,
    setElementToFocus
  } = (0, _react.useContext)(_duellingPicklist.default);
  const isEmpty = (0, _react.useMemo)(() => !_react.default.Children.toArray(children).length, [children]);
  const filteredChildren = _react.default.Children.toArray(children);
  const refs = (0, _react.useMemo)(() => Array.from({
    length: filteredChildren.length
  }, () => /*#__PURE__*/_react.default.createRef()), [filteredChildren.length]);
  const focusItem = (0, _react.useCallback)((ev, itemIndex) => {
    ev.preventDefault();
    refs[itemIndex].current?.focus();
  }, [refs]);
  const handleKeyDown = (0, _react.useCallback)(ev => {
    if (_events.default.isHomeKey(ev)) {
      focusItem(ev, 0);
    } else if (_events.default.isEndKey(ev)) {
      focusItem(ev, refs.length - 1);
    }
  }, [focusItem, refs]);
  const content = filteredChildren.map((child, childIndex) => {
    if (! /*#__PURE__*/_react.default.isValidElement(child)) {
      return child;
    }
    const props = {
      ref: refs[childIndex],
      disabled,
      index: childIndex,
      listIndex: index,
      isLastGroup: child.type === _picklistGroup.default && childIndex === filteredChildren.length - 1
    };
    return /*#__PURE__*/_react.default.cloneElement(child, props);
  });
  (0, _react.useEffect)(() => {
    if (elementToFocus.groupIndex === undefined && elementToFocus.listIndex === index && elementToFocus.itemIndex !== undefined) {
      const itemToBeFocused = refs[elementToFocus.itemIndex]?.current;
      if (itemToBeFocused) {
        itemToBeFocused.focus();
        setElementToFocus();
      } else {
        setElementToFocus(0, index === 0 ? 1 : 0, elementToFocus.groupIndex);
      }
    }
  }, [elementToFocus, index, refs, setElementToFocus]);
  return /*#__PURE__*/_react.default.createElement(_picklist.StyledPicklist, {
    "data-element": "picklist",
    scrollVariant: "light",
    onKeyDown: handleKeyDown
  }, isEmpty && /*#__PURE__*/_react.default.createElement(_picklist.StyledEmptyContainer, null, placeholder), /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.TransitionGroup, {
    component: null
  }, content));
};
exports.Picklist = Picklist;
Picklist.displayName = "Picklist";
var _default = exports.default = Picklist;