"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledPicklistItem = exports.StyledLockIcon = exports.StyledButton = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _button = _interopRequireDefault(require("../../button"));
var _icon = _interopRequireDefault(require("../../icon"));
var _icon2 = _interopRequireDefault(require("../../icon/icon.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledPicklistItem = exports.StyledPicklistItem = _styledComponents.default.li`
  border-radius: var(--borderRadius100);
  ${({
  locked
}) => (0, _styledComponents.css)`
    display: flex;
    align-items: center;
    width: 100%;

    background-color: ${locked ? "var(--colorsUtilityMajor025)" : "var(--colorsUtilityYang100)"};

    ${!locked && (0, _styledComponents.css)`
      box-shadow: var(--boxShadow050);
    `}

    ${locked && (0, _styledComponents.css)`
      border: 1px solid var(--colorsUtilityMajor200);
      color: var(--colorsUtilityYin065);

      ${_icon2.default} {
        color: var(--colorsUtilityMajor200);
      }
    `}

    & + & {
      margin-top: 8px;
    }
  `}
`;
const StyledButton = exports.StyledButton = (0, _styledComponents.default)(_button.default)`
  border-bottom-right-radius: var(--borderRadius100);
  border-top-right-radius: var(--borderRadius100);
  border-bottom-left-radius: var(--borderRadius000);
  border-top-left-radius: var(--borderRadius000);

  :hover {
    border-bottom-right-radius: var(--borderRadius100);
    border-top-right-radius: var(--borderRadius100);
    border-bottom-left-radius: var(--borderRadius000);
    border-top-left-radius: var(--borderRadius000);
  }

  :focus {
    border-bottom-right-radius: var(--borderRadius100);
    border-top-right-radius: var(--borderRadius100);
    border-bottom-left-radius: var(--borderRadius000);
    border-top-left-radius: var(--borderRadius000);
  }

  ${({
  iconType
}) => (0, _styledComponents.css)`
    padding: 0;
    margin-right: 0;
    margin-left: auto;
    height: 40px;
    min-width: 40px;

    &:focus {
      background: ${iconType === "add" ? "var(--colorsActionMajor600)" : "var(--colorsSemanticNegative600)"};
  `}
`;
const StyledLockIcon = exports.StyledLockIcon = (0, _styledComponents.default)(_icon.default)`
  margin-right: 0;
  height: 40px;
  min-width: 40px;

  :focus {
    border-bottom-right-radius: var(--borderRadius100);
    border-top-right-radius: var(--borderRadius100);
    border-bottom-left-radius: var(--borderRadius000);
    border-top-left-radius: var(--borderRadius000);
  }
`;