"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.PicklistItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactTransitionGroup = require("react-transition-group");
var _picklistItem = require("./picklist-item.style");
var _duellingPicklist = _interopRequireDefault(require("../duelling-picklist.context"));
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const PicklistItem = exports.PicklistItem = /*#__PURE__*/_react.default.forwardRef(({
  children,
  type,
  onChange,
  item,
  locked,
  tooltipMessage = "This item is locked and can not be moved",
  index,
  listIndex,
  groupIndex,
  isLastGroup,
  isLastItem,
  ...transitionGroupProps
}, ref) => {
  const {
    setElementToFocus
  } = (0, _react.useContext)(_duellingPicklist.default);
  const picklistItemNodeRef = (0, _react.useRef)(null);
  const calculateFocusIndex = (0, _react.useCallback)(() => {
    if (isLastItem) {
      const toggledListIndex = listIndex === 0 ? 1 : 0;
      const incrementedGroupIndex = groupIndex === 0 && index !== 0 ? 1 : groupIndex;
      return {
        itemIndex: isLastGroup ? 0 : incrementedGroupIndex,
        list: isLastGroup ? toggledListIndex : listIndex,
        group: undefined
      };
    }
    return {
      itemIndex: index,
      list: listIndex,
      group: groupIndex
    };
  }, [groupIndex, index, isLastGroup, isLastItem, listIndex]);
  const updateFocusElement = (0, _react.useCallback)(() => {
    const {
      itemIndex,
      list,
      group
    } = calculateFocusIndex();
    setElementToFocus(itemIndex, list, group);
  }, [calculateFocusIndex, setElementToFocus]);
  const handleClick = (0, _react.useCallback)(() => {
    onChange(item);
    updateFocusElement();
  }, [onChange, item, updateFocusElement]);
  const handleKeydown = (0, _react.useCallback)(event => {
    if (_events.default.isEnterKey(event) || _events.default.isSpaceKey(event)) {
      event.preventDefault();
      onChange(item);
      updateFocusElement();
    }
  }, [onChange, item, updateFocusElement]);
  return /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.CSSTransition, _extends({
    timeout: {
      appear: 500,
      enter: 300,
      exit: 0
    },
    classNames: "picklist-item"
  }, transitionGroupProps, type === "add" ? {
    enter: false
  } : {}, {
    nodeRef: picklistItemNodeRef
  }), /*#__PURE__*/_react.default.createElement(_picklistItem.StyledPicklistItem, {
    onKeyDown: handleKeydown,
    "data-element": "picklist-item",
    locked: locked,
    ref: picklistItemNodeRef
  }, children, !locked && /*#__PURE__*/_react.default.createElement(_picklistItem.StyledButton, {
    buttonType: "primary",
    destructive: type === "remove",
    iconType: type,
    onClick: handleClick,
    ref: ref
  }), locked && /*#__PURE__*/_react.default.createElement(_picklistItem.StyledLockIcon, {
    type: "locked",
    tooltipMessage: tooltipMessage
  })));
});
if (process.env.NODE_ENV !== "production") {
  PicklistItem.propTypes = {
    "children": _propTypes.default.node,
    "groupIndex": _propTypes.default.number,
    "index": _propTypes.default.number,
    "isLastGroup": _propTypes.default.bool,
    "isLastItem": _propTypes.default.bool,
    "item": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.object, _propTypes.default.string]).isRequired,
    "listIndex": _propTypes.default.number,
    "locked": _propTypes.default.bool,
    "onChange": _propTypes.default.func.isRequired,
    "tooltipMessage": _propTypes.default.string,
    "type": _propTypes.default.oneOf(["add", "remove"]).isRequired
  };
}
PicklistItem.displayName = "PicklistItem";
var _default = exports.default = PicklistItem;