"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledPicklistGroupUl = exports.StyledPicklistGroup = exports.StyledGroupWrapper = exports.StyledGroupButton = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _button = _interopRequireDefault(require("../../button"));
var _picklistItem = require("../picklist-item/picklist-item.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledGroupWrapper = exports.StyledGroupWrapper = _styledComponents.default.li`
  ${({
  highlighted,
  type
}) => (0, _styledComponents.css)`
    &:not(:first-of-type) {
      margin-top: 16px;
    }

    ${highlighted && (0, _styledComponents.css)`
      ${_picklistItem.StyledButton} {
        background: ${type === "add" ? "var(--colorsActionMajor600)" : "var(--colorsSemanticNegative600)"}
    `}
  `}
`;
const StyledPicklistGroupUl = exports.StyledPicklistGroupUl = _styledComponents.default.ul`
  padding: 0;
`;
const StyledPicklistGroup = exports.StyledPicklistGroup = _styledComponents.default.li`
  display: flex;
  align-items: center;
  width: 100%;
  margin-bottom: 4px;
`;
const StyledGroupButton = exports.StyledGroupButton = (0, _styledComponents.default)(_button.default)`
  ${({
  iconType
}) => (0, _styledComponents.css)`
    padding: 0;
    margin-right: 0;
    margin-left: auto;
    height: 40px;
    min-width: 40px;
    border: none;

    &:focus {
      > span {
        color: var(--colorsActionMajorYang100);
      }
      background: ${iconType === "add" ? "var(--colorsActionMajor600)" : "var(--colorsSemanticNegative600)"}
  `}
`;