"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.PicklistGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactTransitionGroup = require("react-transition-group");
var _picklistGroup = require("./picklist-group.style");
var _duellingPicklist = _interopRequireDefault(require("../duelling-picklist.context"));
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const PicklistGroup = exports.PicklistGroup = /*#__PURE__*/_react.default.forwardRef(({
  title,
  children,
  type,
  onChange,
  index,
  listIndex,
  isLastGroup,
  ...transitionGroupProps
}, ref) => {
  const {
    setElementToFocus,
    elementToFocus
  } = (0, _react.useContext)(_duellingPicklist.default);
  const [highlighted, setHighlighted] = (0, _react.useState)(false);
  const filteredChildren = _react.default.Children.toArray(children);
  const handleClick = (0, _react.useCallback)(() => {
    onChange();
    setElementToFocus(index, listIndex);
  }, [index, listIndex, onChange, setElementToFocus]);
  const handleKeydown = (0, _react.useCallback)(event => {
    if (_events.default.isEnterKey(event) || _events.default.isSpaceKey(event)) {
      event.preventDefault();
      onChange();
      setElementToFocus(index, listIndex);
    }
  }, [index, listIndex, onChange, setElementToFocus]);
  const refs = (0, _react.useMemo)(() => Array.from({
    length: filteredChildren.length
  }, () => /*#__PURE__*/_react.default.createRef()), [filteredChildren.length]);
  const content = _react.default.Children.map(children, (child, childIndex) => {
    if (! /*#__PURE__*/_react.default.isValidElement(child)) {
      return child;
    }
    const props = {
      ref: refs[childIndex],
      index: childIndex,
      listIndex,
      groupIndex: index,
      isLastGroup,
      isLastItem: childIndex === filteredChildren.length - 1
    };
    return /*#__PURE__*/_react.default.cloneElement(child, props);
  });
  (0, _react.useEffect)(() => {
    if (elementToFocus.groupIndex === index && elementToFocus.listIndex === listIndex && elementToFocus.itemIndex !== undefined) {
      refs[elementToFocus.itemIndex].current?.focus();
      setElementToFocus();
    }
  }, [elementToFocus, index, isLastGroup, listIndex, refs, setElementToFocus]);
  return /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.CSSTransition, _extends({
    timeout: {
      appear: 500,
      enter: 300,
      exit: 0
    },
    classNames: "picklist-group"
  }, transitionGroupProps, type === "add" ? {
    enter: false
  } : {}), /*#__PURE__*/_react.default.createElement(_picklistGroup.StyledGroupWrapper, {
    highlighted: highlighted,
    type: type
  }, /*#__PURE__*/_react.default.createElement(_picklistGroup.StyledPicklistGroupUl, null, /*#__PURE__*/_react.default.createElement(_picklistGroup.StyledPicklistGroup, {
    onKeyDown: handleKeydown,
    "data-element": "picklist-group"
  }, title, /*#__PURE__*/_react.default.createElement(_picklistGroup.StyledGroupButton, {
    buttonType: "secondary",
    destructive: type === "remove",
    iconType: type,
    onClick: handleClick,
    onMouseEnter: () => setHighlighted(true),
    onMouseLeave: () => setHighlighted(false),
    onFocus: () => setHighlighted(true),
    onBlur: () => setHighlighted(false),
    ref: ref
  })), /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.TransitionGroup, {
    component: null
  }, content))));
});
if (process.env.NODE_ENV !== "production") {
  PicklistGroup.propTypes = {
    "children": _propTypes.default.node,
    "index": _propTypes.default.number,
    "isLastGroup": _propTypes.default.bool,
    "listIndex": _propTypes.default.number,
    "onChange": _propTypes.default.func.isRequired,
    "title": _propTypes.default.node,
    "type": _propTypes.default.oneOf(["add", "remove"]).isRequired
  };
}
PicklistGroup.displayName = "PicklistGroup";
var _default = exports.default = PicklistGroup;