"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DuellingPicklist = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("../../style/utils");
var _duellingPicklist = require("./duelling-picklist.style");
var _picklist = require("./picklist/picklist.component");
var _duellingPicklist2 = _interopRequireDefault(require("./duelling-picklist.context"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const DuellingPicklist = ({
  children,
  disabled,
  leftControls,
  rightControls,
  leftLabel,
  rightLabel,
  ...rest
}) => {
  const shouldDisplayLabels = leftLabel || rightLabel;
  const shouldDisplayControls = leftControls || rightControls;
  const [elementToFocus, setElementToFocus] = (0, _react.useState)({});
  let pickListIndex = 0;
  const addElementToFocus = (itemIndex, listIndex, groupIndex) => {
    setElementToFocus({
      itemIndex,
      listIndex,
      groupIndex
    });
  };
  const getIndex = () => {
    const index = pickListIndex;
    pickListIndex += 1;
    return index;
  };
  const clonedChildren = _react.default.Children.map(children, child => {
    if ( /*#__PURE__*/_react.default.isValidElement(child) && child.type === _picklist.Picklist) {
      return /*#__PURE__*/_react.default.cloneElement(child, {
        index: getIndex()
      });
    }
    return child;
  });
  return /*#__PURE__*/_react.default.createElement(_duellingPicklist.StyledDuellingPicklistOverlay, _extends({
    disabled: disabled,
    "data-component": "duelling-picklist"
  }, (0, _utils.filterStyledSystemMarginProps)(rest)), shouldDisplayLabels && /*#__PURE__*/_react.default.createElement(_duellingPicklist.StyledLabelContainer, null, /*#__PURE__*/_react.default.createElement(_duellingPicklist.StyledLabel, {
    "data-element": "picklist-left-label"
  }, leftLabel), /*#__PURE__*/_react.default.createElement(_duellingPicklist.StyledLabel, {
    "data-element": "picklist-right-label"
  }, rightLabel)), shouldDisplayControls && /*#__PURE__*/_react.default.createElement(_duellingPicklist.StyledControlsContainer, null, /*#__PURE__*/_react.default.createElement(_duellingPicklist.StyledControl, {
    "data-element": "picklist-left-control"
  }, leftControls), /*#__PURE__*/_react.default.createElement(_duellingPicklist.StyledControl, {
    "data-element": "picklist-right-label"
  }, rightControls)), /*#__PURE__*/_react.default.createElement(_duellingPicklist2.default.Provider, {
    value: {
      setElementToFocus: addElementToFocus,
      elementToFocus
    }
  }, /*#__PURE__*/_react.default.createElement(_duellingPicklist.StyledDuellingPicklist, null, clonedChildren)));
};
exports.DuellingPicklist = DuellingPicklist;
var _default = exports.default = DuellingPicklist;