import React from "react";
import { MarginProps } from "styled-system";
export interface DuellingPicklistProps extends MarginProps {
    /**
     * Content of the component, should contain two Picklist children
     * and a PicklistDivider
     */
    children?: React.ReactNode;
    /** Indicate if component is disabled */
    disabled?: boolean;
    /** Place for components like Search or Filter placed above the left list */
    leftControls?: React.ReactNode;
    /** Left list label */
    leftLabel?: string;
    /** Place for components like Search or Filter placed above the right list */
    rightControls?: React.ReactNode;
    /** Right list label */
    rightLabel?: string;
}
export declare const DuellingPicklist: ({ children, disabled, leftControls, rightControls, leftLabel, rightLabel, ...rest }: DuellingPicklistProps) => React.JSX.Element;
export default DuellingPicklist;
