"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledSidebarToggleButton = exports.StyledSidebarTitle = exports.StyledSidebarHeader = exports.StyledDrawerWrapper = exports.StyledDrawerSidebar = exports.StyledDrawerContent = exports.StyledDrawerChildren = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _tabs = _interopRequireDefault(require("../tabs/tabs.style"));
var _box = _interopRequireDefault(require("../box"));
var _stickyFooter = _interopRequireDefault(require("../../__internal__/sticky-footer/sticky-footer.style"));
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultExpandedWidth = "var(--sizing500)";
const StyledSidebarHeader = exports.StyledSidebarHeader = _styledComponents.default.div`
  ${({
  isExpanded
}) => (0, _styledComponents.css)`
    position: sticky;
    top: 0;

    ${isExpanded && (0, _styledComponents.css)`
      border-bottom: var(--sizing010) solid #ccd6db;
    `}
  `}
`;
const StyledSidebarTitle = exports.StyledSidebarTitle = _styledComponents.default.div`
  white-space: nowrap;
  padding: var(--spacing300) var(--spacing500);
`;
const StyledDrawerChildren = exports.StyledDrawerChildren = _styledComponents.default.div`
  flex: 1;
  margin-left: 1px;
  overflow: auto;
`;
const StyledDrawerSidebar = exports.StyledDrawerSidebar = (0, _styledComponents.default)(_box.default)`
  ${({
  hasControls,
  isExpanded
}) => (0, _styledComponents.css)`
      ${!isExpanded && (0, _styledComponents.css)`
        display: none;
        opacity: 0;
      `}

      ${isExpanded && (0, _styledComponents.css)`
        display: flex;
        flex-direction: column;
        flex: 1 1 0%;
      `}

      ${hasControls && (0, _styledComponents.css)`
        ${_tabs.default} {
          margin-top: 48px;
          ${!isExpanded && (0, _styledComponents.css)`
            display: none;
          `}
        }
      `}
    `}

  &::-webkit-scrollbar {
    width: 12px;
  }
`;
const sidebarVisible = () => (0, _styledComponents.keyframes)`
  0% {opacity: 0;}
  50% {opacity: 0;}
  100% {opacity: 1;}
`;
const sidebarHidden = () => (0, _styledComponents.keyframes)`
  0% {opacity: 1;}
  100% {opacity: 0; display: none;}
`;
const drawerOpen = expandedWidth => (0, _styledComponents.keyframes)`
  0% {
    width: ${defaultExpandedWidth};
    overflow: hidden;
    min-width: ${defaultExpandedWidth};
  }
  100% {
    width: ${expandedWidth};
    min-width: 52px;
  }
`;
const drawerClose = expandedWidth => (0, _styledComponents.keyframes)`
  0% {width: ${expandedWidth};}
  100% {width: ${defaultExpandedWidth};}
`;
const buttonOpen = () => (0, _styledComponents.keyframes)`
  0% {float: right;}
  100% {float: right;}
`;
const buttonClose = () => (0, _styledComponents.keyframes)`
  0% {float: right;}
  80% {float: right;}
  100% {float: left;}
`;
const StyledDrawerContent = exports.StyledDrawerContent = _styledComponents.default.div`
  display: flex;
  flex-direction: column;
  min-width: ${defaultExpandedWidth};
  width: ${defaultExpandedWidth};
  min-height: 40px;
  height: auto;
  position: relative;
  overflow: auto;

  ${({
  backgroundColor
}) => (0, _styledComponents.css)`
    background-color: ${backgroundColor || "var(--colorsUtilityMajor040)"};
    border-right: 1px solid ${backgroundColor || "var(--colorsUtilityMajor075)"};
  `};

  &.open {
    min-width: 52px;
    width: ${({
  expandedWidth
}) => expandedWidth};

    ${StyledDrawerSidebar}, ${StyledSidebarTitle} {
      display: block;
      opacity: 1;
    }
  }

  &.opening {
    animation: ${({
  animationDuration,
  expandedWidth
}) => (0, _styledComponents.css)`
        ${drawerOpen(expandedWidth)} ${animationDuration}
      `}
      ease-in-out;

    ${StyledDrawerSidebar}, ${StyledSidebarTitle} {
      animation: ${sidebarVisible}
        ${({
  animationDuration
}) => animationDuration} ease-in-out;
    }
  }

  &.closed {
    overflow: hidden;
    ${StyledDrawerSidebar}, ${StyledSidebarTitle}, ${_stickyFooter.default} {
      display: block;
      opacity: 0;
    }
  }

  &.closing {
    animation: ${({
  animationDuration,
  expandedWidth
}) => (0, _styledComponents.css)`
        ${drawerClose(expandedWidth)} ${animationDuration}
      `}
      ease-in-out;

    ${StyledDrawerSidebar}, ${StyledSidebarTitle}, ${_stickyFooter.default} {
      animation: ${sidebarHidden}
        ${({
  animationDuration
}) => animationDuration} ease-in-out;
    }
  }
`;
const oldFocusStyling = `
  outline: solid 3px var(--colorsSemanticFocus500);
`;
const StyledSidebarToggleButton = exports.StyledSidebarToggleButton = _styledComponents.default.button.attrs({
  type: "button"
})`
  ${({
  animationDuration,
  isExpanded
}) => (0, _styledComponents.css)`
    position: absolute;
    top: var(--spacing300);
    right: 8px;
    padding: var(--spacing100);
    width: var(--spacing300);
    height: var(--spacing300);
    display: flex;
    justify-content: center;
    align-items: center;
    transition: margin-right ${animationDuration} ease-in-out;
    background-color: transparent;
    border: none;
    z-index: 1;
    animation: ${buttonClose} ${animationDuration} ease-in-out;
    border-radius: var(--borderRadius050);

    ${({
  theme
}) => `
      &:focus {
        ${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}
      }
    `}

    &:hover {
      cursor: pointer;
    }

    ${isExpanded && (0, _styledComponents.css)`
      transform: scaleX(-1);
      animation: ${buttonOpen} ${animationDuration} ease-in-out;
    `}
  `}
`;
StyledSidebarToggleButton.defaultProps = {
  theme: _base.default
};
const StyledDrawerWrapper = exports.StyledDrawerWrapper = _styledComponents.default.div`
  display: flex;
  height: ${({
  height
}) => height};
`;