"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DrawerSidebarContext = exports.Drawer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _usePrevious = _interopRequireDefault(require("../../hooks/__internal__/usePrevious"));
var _icon = _interopRequireDefault(require("../icon"));
var _drawer = require("./drawer.style");
var _stickyFooter = _interopRequireDefault(require("../../__internal__/sticky-footer"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const DrawerSidebarContext = exports.DrawerSidebarContext = /*#__PURE__*/_react.default.createContext({});
const Drawer = ({
  defaultExpanded = true,
  expanded,
  onChange,
  children,
  expandedWidth = "40%",
  sidebar,
  animationDuration = "400ms",
  backgroundColor,
  title,
  footer,
  showControls,
  height = "100%",
  stickyHeader,
  stickyFooter,
  ...rest
}) => {
  const drawerSidebarContentRef = (0, _react.useRef)(null);
  const scrollableContentRef = (0, _react.useRef)(null);
  const isControlled = (0, _react.useRef)(expanded !== undefined);
  const [isOpening, setIsOpening] = (0, _react.useState)(false);
  const [isClosing, setIsClosing] = (0, _react.useState)(false);
  const [isExpanded, setIsExpanded] = (0, _react.useState)(isControlled.current ? expanded : defaultExpanded);
  const timer = (0, _react.useRef)(null);
  const getAnimationDuration = (0, _react.useCallback)(() => {
    if (animationDuration.indexOf("ms") !== -1) {
      const animationTime = animationDuration.substring(0, animationDuration.length - 2);
      return parseInt(animationTime);
    }
    if (animationDuration.indexOf(".") !== -1 || animationDuration.indexOf("s") !== -1) {
      const animationTime = animationDuration.substring(0, animationDuration.length - 1);
      return parseFloat(animationTime) * 1000;
    }
    return parseInt(animationDuration);
  }, [animationDuration]);
  const toggleAnimation = (0, _react.useCallback)(() => {
    const timeout = getAnimationDuration();
    if (timer.current) {
      clearTimeout(timer.current);
    }
    if (!isExpanded) {
      setIsClosing(false);
      setIsOpening(true);
      timer.current = setTimeout(() => {
        setIsOpening(false);
      }, timeout);
    } else {
      setIsOpening(false);
      setIsClosing(true);
      timer.current = setTimeout(() => {
        setIsClosing(false);
      }, timeout);
    }
  }, [getAnimationDuration, isExpanded]);
  const previousValue = (0, _usePrevious.default)(expanded);
  (0, _react.useEffect)(() => {
    const message = "Drawer should not switch from uncontrolled to controlled" + " (or vice versa). Decide between using a controlled or uncontrolled Drawer element" + " for the lifetime of the component";
    !(isControlled.current === (expanded !== undefined)) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, message) : (0, _invariant.default)(false) : void 0;
    if (isControlled.current && previousValue !== expanded) {
      setIsExpanded(expanded);
      if (!showControls && ![expanded, previousValue].includes(undefined)) {
        toggleAnimation();
      }
    }
  }, [expanded, toggleAnimation, previousValue, showControls]);
  (0, _react.useEffect)(() => {
    return function cleanup() {
      if (timer.current) {
        clearTimeout(timer.current);
      }
    };
  }, []);
  const toggleDrawer = (0, _react.useCallback)(ev => {
    setIsExpanded(!isExpanded);
    if (onChange) onChange(ev, !isExpanded);
    if (isExpanded && drawerSidebarContentRef.current) {
      drawerSidebarContentRef.current.scrollTop = 0;
    }
    toggleAnimation();
  }, [toggleAnimation, isExpanded, onChange]);
  const guid = (0, _react.useRef)((0, _guid.default)());
  const sidebarId = `DrawerSidebar_${guid.current}`;
  const getClassNames = (0, _react.useCallback)(() => {
    const classes = [isExpanded ? "open" : "closed"];
    if (isOpening) {
      classes.push("opening");
    }
    if (isClosing) {
      classes.push("closing");
    }
    return classes.join(" ");
  }, [isExpanded, isOpening, isClosing]);
  const getControls = () => {
    if (showControls === undefined) return null;
    return /*#__PURE__*/_react.default.createElement(_drawer.StyledSidebarToggleButton, {
      "aria-label": "toggle sidebar",
      "aria-expanded": isExpanded,
      "aria-controls": sidebarId,
      "data-element": "drawer-toggle",
      onClick: toggleDrawer,
      isExpanded: isExpanded,
      animationDuration: animationDuration
    }, /*#__PURE__*/_react.default.createElement(_icon.default, {
      type: "chevron_right"
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_drawer.StyledDrawerWrapper, _extends({
    "data-component": "drawer",
    height: height
  }, rest), /*#__PURE__*/_react.default.createElement(_drawer.StyledDrawerContent, {
    expandedWidth: expandedWidth,
    animationDuration: animationDuration,
    className: getClassNames(),
    ref: drawerSidebarContentRef,
    backgroundColor: backgroundColor,
    "data-element": "drawer-content"
  }, stickyHeader && /*#__PURE__*/_react.default.createElement(_drawer.StyledSidebarHeader, {
    isExpanded: isExpanded
  }, title && /*#__PURE__*/_react.default.createElement(_drawer.StyledSidebarTitle, null, title), getControls()), !stickyHeader && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title && /*#__PURE__*/_react.default.createElement(_drawer.StyledSidebarTitle, null, title), getControls()), /*#__PURE__*/_react.default.createElement(_drawer.StyledDrawerSidebar, {
    hasControls: !!showControls,
    id: sidebarId,
    isExpanded: isExpanded,
    role: "navigation",
    overflowY: isExpanded ? "auto" : undefined,
    scrollVariant: "light",
    ref: scrollableContentRef
  }, /*#__PURE__*/_react.default.createElement(DrawerSidebarContext.Provider, {
    value: {
      isInSidebar: true
    }
  }, sidebar), footer && /*#__PURE__*/_react.default.createElement(_stickyFooter.default, {
    containerRef: scrollableContentRef,
    disableSticky: !stickyFooter
  }, footer))), /*#__PURE__*/_react.default.createElement(_drawer.StyledDrawerChildren, null, children));
};
exports.Drawer = Drawer;
var _default = exports.default = Drawer;