"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledIcon = exports.StyledDraggableItem = exports.StyledDraggableContainer = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _styledSystem = require("styled-system");
var _themes = require("../../../style/themes");
var _icon = _interopRequireDefault(require("../../icon"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const StyledDraggableContainer = exports.StyledDraggableContainer = _styledComponents.default.div`
  ${_styledSystem.margin}
`;
const StyledDraggableItem = exports.StyledDraggableItem = _styledComponents.default.div`
  display: flex;
  align-items: center;
  border-bottom: 1px solid var(--colorsUtilityMajor050);
  ${_styledSystem.padding}
  cursor: move;

  opacity: ${({
  isDragging
}) => isDragging ? "0" : "1"};
`;
const StyledIcon = exports.StyledIcon = (0, _styledComponents.default)(_icon.default)`
  margin-left: auto;
`;
StyledDraggableContainer.defaultProps = {
  theme: _themes.baseTheme
};
StyledDraggableItem.defaultProps = {
  theme: _themes.baseTheme
};