"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactDnd = require("react-dnd");
var _draggableItem = require("../draggable-item/draggable-item.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const DropTarget = ({
  children,
  getOrder,
  ...rest
}) => {
  const [, drop] = (0, _reactDnd.useDrop)({
    accept: "draggableItem",
    drop(item) {
      // istanbul ignore else
      if (getOrder) {
        getOrder(item?.id);
      }
    }
  });
  return /*#__PURE__*/_react.default.createElement(_draggableItem.StyledDraggableContainer, _extends({
    ref: drop
  }, rest), children);
};
var _default = exports.default = DropTarget;