"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledDismissibleBox = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _box = _interopRequireDefault(require("../box"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledDismissibleBox = exports.StyledDismissibleBox = (0, _styledComponents.default)(_box.default)`
  ${({
  hasBorderLeftHighlight = true,
  variant = "light"
}) => (0, _styledComponents.css)`
    background-color: ${variant === "light" ? "#FFFFFF" : "var(--colorsUtilityMajor050)"};

    border: 1px solid var(--colorsUtilityMajor100);
    display: flex;
    justify-content: space-between;
    word-break: break-word;

    ${hasBorderLeftHighlight && `
      border-left: none;
      box-shadow: -4px 0 0 0 var(--colorsUtilityMajor400);
    `}

    ${_icon.default}:hover {
      color: var(--colorsActionMinor600);
    }
  `}
`;