"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DismissibleBox = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _dismissibleBox = require("./dismissible-box.style");
var _iconButton = _interopRequireDefault(require("../icon-button"));
var _icon = _interopRequireDefault(require("../icon"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const DismissibleBox = ({
  children,
  closeButtonDataProps,
  onClose,
  borderRadius = "borderRadius100",
  ...rest
}) => {
  const locale = (0, _useLocale.default)();
  return /*#__PURE__*/_react.default.createElement(_dismissibleBox.StyledDismissibleBox, _extends({
    p: "20px 24px 20px 20px",
    "data-component": "dismissible-box",
    borderRadius: borderRadius
  }, rest), children, /*#__PURE__*/_react.default.createElement("span", {
    "data-element": "close-button-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_iconButton.default, _extends({
    onClick: onClose,
    "aria-label": locale.dismissibleBox.ariaLabels.close(),
    ml: 3
  }, (0, _tags.default)("close-button", {
    "data-element": "close-button",
    ...closeButtonDataProps
  })), /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "close",
    color: "--colorsActionMinor500"
  }))));
};
exports.DismissibleBox = DismissibleBox;
var _default = exports.default = DismissibleBox;