"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledDialogTitle = exports.StyledDialogInnerContent = exports.StyledDialogContent = exports.StyledDialog = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _formStyleUtils = require("../../style/utils/form-style-utils");
var _form = require("../form/form.style");
var _heading = require("../heading/heading.style");
var _iconButton = _interopRequireDefault(require("../icon-button/icon-button.style"));
var _dialog = require("./dialog.config");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const dialogSizes = {
  auto: "fit-content",
  "extra-small": "300px",
  small: "380px",
  "medium-small": "540px",
  medium: "750px",
  "medium-large": "850px",
  large: "960px",
  "extra-large": "1080px"
};
const calculatePaddingTopInnerContent = ({
  py,
  p
}) => [py, p].some(padding => padding !== undefined) ? 0 : `${_dialog.CONTENT_TOP_PADDING}px`;
const StyledDialog = exports.StyledDialog = _styledComponents.default.div`
  box-shadow: var(--boxShadow300);
  display: flex;
  flex-direction: column;
  border-radius: var(--borderRadius200);
  position: fixed;
  top: 50%;
  z-index: ${({
  theme
}) => theme.zIndex.modal};
  max-height: ${({
  topMargin
}) => `calc(100vh - ${topMargin}px)`};

  &:focus {
    outline: none;
  }

  ${({
  backgroundColor
}) => (0, _styledComponents.css)`
      background-color: ${backgroundColor};
    `}

  ${({
  size
}) => size && (0, _styledComponents.css)`
      max-width: ${dialogSizes[size]};
      width: 100%;
    `}

  ${({
  dialogHeight
}) => dialogHeight && (0, _styledComponents.css)`
      height: ${dialogHeight}px;
    `}

  ${_form.StyledForm} {
    padding-bottom: 0px;
    box-sizing: border-box;
  }

  ${_form.StyledFormContent}.sticky {
    ${props => (0, _formStyleUtils.calculateFormSpacingValues)(props, true)}
  }

  ${_form.StyledFormFooter}.sticky {
    ${_formStyleUtils.calculateWidthValue}
    ${props => (0, _formStyleUtils.calculateFormSpacingValues)(props, false)}
    border-bottom-right-radius: var(--borderRadius200);
    border-bottom-left-radius: var(--borderRadius200);
  }

  > ${_iconButton.default} {
    margin: 0;
    position: absolute;
    right: 33px;
    top: 32px;
    z-index: 1;

    &:hover {
      color: #255bc7;
    }
  }
`;
const StyledDialogTitle = exports.StyledDialogTitle = _styledComponents.default.div`
  background-color: var(--colorsUtilityYang100);
  padding: 23px ${_dialog.HORIZONTAL_PADDING}px 0;
  border-bottom: 1px solid #ccd6db;
  border-top-right-radius: var(--borderRadius200);
  border-top-left-radius: var(--borderRadius200);
  ${({
  showCloseIcon
}) => showCloseIcon && "padding-right: 85px"};

  ${_heading.StyledHeaderContent} {
    align-items: baseline;
  }

  ${_heading.StyledHeading} {
    margin-bottom: 20px;

    ${_heading.StyledHeadingTitle} {
      color: var(--colorsUtilityYin090);
      display: block;
      overflow: hidden;
      text-overflow: ellipsis;
      padding: ${({
  hasSubtitle
}) => !hasSubtitle && "4px 0px"};
    }
  }
`;
const StyledDialogContent = exports.StyledDialogContent = _styledComponents.default.div`
  box-sizing: border-box;
  display: flex;
  flex-direction: column;
  ${({
  hasStickyFooter
}) => !hasStickyFooter && (0, _styledComponents.css)`
      overflow-y: auto;
    `}
  width: 100%;
  flex: 1;
  padding: 0px ${_dialog.HORIZONTAL_PADDING}px ${_dialog.CONTENT_BOTTOM_PADDING}px;
  ${_styledSystem.padding}
`;
const StyledDialogInnerContent = exports.StyledDialogInnerContent = _styledComponents.default.div`
  position: relative;
  flex: 1;
  padding-top: ${calculatePaddingTopInnerContent};
`;
StyledDialog.defaultProps = {
  theme: _base.default
};
StyledDialogContent.defaultProps = {
  theme: _base.default
};