"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Dialog = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _modal = _interopRequireDefault(require("../modal"));
var _heading = _interopRequireDefault(require("../heading"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags"));
var _useResizeObserver = _interopRequireDefault(require("../../hooks/__internal__/useResizeObserver"));
var _dialog = require("./dialog.style");
var _dialog2 = require("./dialog.config");
var _focusTrap = _interopRequireDefault(require("../../__internal__/focus-trap"));
var _iconButton = _interopRequireDefault(require("../icon-button"));
var _icon = _interopRequireDefault(require("../icon"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _useIsStickyFooterForm = _interopRequireDefault(require("../../hooks/__internal__/useIsStickyFooterForm"));
var _useModalAria = _interopRequireDefault(require("../../hooks/__internal__/useModalAria/useModalAria"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const PADDING_VALUES = [0, 1, 2, 3, 4, 5, 6, 7, 8];
const Dialog = exports.Dialog = /*#__PURE__*/(0, _react.forwardRef)(({
  className,
  children,
  open,
  height,
  size = "medium",
  title,
  disableEscKey,
  subtitle,
  disableAutoFocus = false,
  focusFirstElement,
  focusableSelectors,
  onCancel,
  showCloseIcon = true,
  bespokeFocusTrap,
  disableClose,
  help,
  role = "dialog",
  contentPadding = {},
  greyBackground = false,
  focusableContainers,
  topModalOverride,
  closeButtonDataProps,
  ...rest
}, ref) => {
  const locale = (0, _useLocale.default)();
  const containerRef = (0, _react.useRef)(null);
  const innerContentRef = (0, _react.useRef)(null);
  const titleRef = (0, _react.useRef)(null);
  const listenersAdded = (0, _react.useRef)(false);
  const {
    current: titleId
  } = (0, _react.useRef)((0, _guid.default)());
  const {
    current: subtitleId
  } = (0, _react.useRef)((0, _guid.default)());
  const hasStickyFooter = (0, _useIsStickyFooterForm.default)(children);
  const isTopModal = (0, _useModalAria.default)(containerRef);
  (0, _react.useImperativeHandle)(ref, () => ({
    focus() {
      containerRef.current?.focus();
    }
  }), []);
  const centerDialog = (0, _react.useCallback)(() => {
    /* istanbul ignore if */
    if (!containerRef.current) {
      return;
    }
    const {
      width: dialogWidth,
      height: dialogHeight
    } = containerRef.current.getBoundingClientRect();
    let midPointY = window.innerHeight / 2;
    let midPointX = window.innerWidth / 2;
    midPointY -= dialogHeight / 2;
    midPointX -= dialogWidth / 2;
    if (midPointY < _dialog2.TOP_MARGIN) {
      midPointY = _dialog2.TOP_MARGIN;
    }
    if (midPointX < 0) {
      midPointX = 0;
    }
    containerRef.current.style.top = `${midPointY}px`;
    containerRef.current.style.left = `${midPointX}px`;
  }, []);
  (0, _useResizeObserver.default)(innerContentRef, centerDialog, !open);
  const addListeners = (0, _react.useCallback)(() => {
    /* istanbul ignore else */
    if (!listenersAdded.current) {
      window.addEventListener("resize", centerDialog);
      listenersAdded.current = true;
    }
  }, [centerDialog]);
  const removeListeners = (0, _react.useCallback)(() => {
    if (listenersAdded.current) {
      window.removeEventListener("resize", centerDialog);
      listenersAdded.current = false;
    }
  }, [centerDialog]);
  (0, _react.useEffect)(() => {
    if (open) {
      addListeners();
    }
    if (!open) {
      removeListeners();
    }
    return () => {
      removeListeners();
    };
  }, [open, addListeners, removeListeners]);
  (0, _react.useLayoutEffect)(() => {
    if (open) {
      centerDialog();
    }
  }, [centerDialog, open, height]);
  const closeIcon = () => {
    if (!showCloseIcon || !onCancel) return null;
    return /*#__PURE__*/_react.default.createElement(_iconButton.default, _extends({
      "aria-label": locale.dialog.ariaLabels.close(),
      onClick: onCancel,
      disabled: disableClose
    }, (0, _tags.default)("close", {
      "data-element": "close",
      ...closeButtonDataProps
    })), /*#__PURE__*/_react.default.createElement(_icon.default, {
      type: "close"
    }));
  };
  const dialogTitle = () => {
    if (!title) return null;
    return /*#__PURE__*/_react.default.createElement(_dialog.StyledDialogTitle, {
      showCloseIcon: showCloseIcon,
      hasSubtitle: !!subtitle,
      ref: titleRef
    }, typeof title === "string" ? /*#__PURE__*/_react.default.createElement(_heading.default, {
      "data-element": "dialog-title",
      title: title,
      titleId: titleId,
      subheader: subtitle,
      subtitleId: subtitleId,
      divider: false,
      help: help
    }) : title);
  };
  let dialogHeight = height;
  if (height && height.match(/px$/)) {
    dialogHeight = height.replace("px", "");
  }
  const dialogProps = {
    size,
    dialogHeight,
    "aria-labelledby": title && typeof title === "string" ? titleId : rest["aria-labelledby"],
    "aria-describedby": subtitle && typeof subtitle === "string" ? subtitleId : rest["aria-describedby"],
    "aria-label": rest["aria-label"]
  };
  const componentTags = {
    "data-component": rest["data-component"] || "dialog",
    "data-element": rest["data-element"],
    "data-role": rest["data-role"]
  };
  return /*#__PURE__*/_react.default.createElement(_modal.default, _extends({
    open: open,
    onCancel: onCancel,
    disableEscKey: disableEscKey,
    disableClose: disableClose,
    className: className ? `${className} carbon-dialog` : "carbon-dialog",
    topModalOverride: topModalOverride
  }, componentTags), /*#__PURE__*/_react.default.createElement(_focusTrap.default, {
    autoFocus: !disableAutoFocus,
    focusFirstElement: focusFirstElement,
    bespokeTrap: bespokeFocusTrap,
    focusableSelectors: focusableSelectors,
    wrapperRef: containerRef,
    isOpen: open,
    additionalWrapperRefs: focusableContainers
  }, /*#__PURE__*/_react.default.createElement(_dialog.StyledDialog, _extends({
    "aria-modal": isTopModal ? true : undefined,
    ref: containerRef,
    topMargin: _dialog2.TOP_MARGIN
  }, dialogProps, {
    "data-component": "dialog",
    "data-element": "dialog",
    "data-role": rest["data-role"],
    role: role,
    tabIndex: -1
  }, contentPadding, {
    backgroundColor: greyBackground ? "var(--colorsUtilityMajor025)" : "var(--colorsUtilityYang100)"
  }), dialogTitle(), closeIcon(), /*#__PURE__*/_react.default.createElement(_dialog.StyledDialogContent, _extends({}, contentPadding, {
    hasStickyFooter: hasStickyFooter
  }), /*#__PURE__*/_react.default.createElement(_dialog.StyledDialogInnerContent, _extends({
    ref: innerContentRef
  }, contentPadding), children)))));
});
if (process.env.NODE_ENV !== "production") {
  Dialog.propTypes = {
    "aria-describedby": _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "aria-labelledby": _propTypes.default.string,
    "ariaRole": _propTypes.default.string,
    "bespokeFocusTrap": _propTypes.default.func,
    "children": _propTypes.default.node,
    "className": _propTypes.default.string,
    "closeButtonDataProps": _propTypes.default.shape({
      "data-element": _propTypes.default.string,
      "data-role": _propTypes.default.string
    }),
    "contentPadding": _propTypes.default.shape({
      "p": _propTypes.default.oneOf([0, 1, 2, 3, 4, 5, 6, 7, 8]),
      "px": _propTypes.default.oneOf([0, 1, 2, 3, 4, 5, 6, 7, 8]),
      "py": _propTypes.default.oneOf([0, 1, 2, 3, 4, 5, 6, 7, 8])
    }),
    "data-component": _propTypes.default.string,
    "data-element": _propTypes.default.string,
    "data-role": _propTypes.default.string,
    "disableAutoFocus": _propTypes.default.bool,
    "disableClose": _propTypes.default.bool,
    "disableEscKey": _propTypes.default.bool,
    "disableFocusTrap": _propTypes.default.bool,
    "enableBackgroundUI": _propTypes.default.bool,
    "focusableContainers": _propTypes.default.arrayOf(_propTypes.default.shape({
      "current": function (props, propName) {
        if (props[propName] == null) {
          return null;
        } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
          return new Error("Expected prop '" + propName + "' to be of type Element");
        }
      }
    })),
    "focusableSelectors": _propTypes.default.string,
    "focusFirstElement": _propTypes.default.oneOfType([function (props, propName) {
      if (props[propName] == null) {
        return new Error("Prop '" + propName + "' is required but wasn't specified");
      } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
        return new Error("Expected prop '" + propName + "' to be of type Element");
      }
    }, _propTypes.default.shape({
      "current": function (props, propName) {
        if (props[propName] == null) {
          return null;
        } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
          return new Error("Expected prop '" + propName + "' to be of type Element");
        }
      }
    })]),
    "greyBackground": _propTypes.default.bool,
    "height": _propTypes.default.string,
    "help": _propTypes.default.string,
    "onCancel": _propTypes.default.func,
    "open": _propTypes.default.bool.isRequired,
    "role": _propTypes.default.string,
    "showCloseIcon": _propTypes.default.bool,
    "size": _propTypes.default.oneOf(["auto", "extra-large", "extra-small", "large", "medium-large", "medium-small", "medium", "small"]),
    "subtitle": _propTypes.default.node,
    "timeout": _propTypes.default.number,
    "title": _propTypes.default.node,
    "topModalOverride": _propTypes.default.bool
  };
}
var _default = exports.default = Dialog;