"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _content = _interopRequireDefault(require("./content.style"));
var _iconButton = _interopRequireDefault(require("../icon-button/icon-button.style"));
var _fullScreenHeading = _interopRequireDefault(require("../../__internal__/full-screen-heading/full-screen-heading.style"));
var _heading = require("../heading/heading.style");
var _form = require("../form/form.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledDialogFullScreen = _styledComponents.default.div`
  :focus {
    outline: none;
  }

  background-color: var(--colorsUtilityMajor025);
  height: 100%;
  left: 0;
  position: fixed;
  top: 0;
  width: 100%;
  z-index: ${({
  theme
}) => theme.zIndex.fullScreenModal}; // TODO (tokens): implement elevation tokens - FE-4437
  display: flex;
  flex-direction: column;

  ${_form.StyledForm} {
    min-height: 100%;
  }

  ${_heading.StyledHeaderContent} {
    align-items: baseline;
  }

  > ${_iconButton.default} {
    margin: 0;
    position: absolute;
    right: 40px;
    top: 26px;
    z-index: 1;
  }

  /**
    The following CSS is for a legacy use of the Pages component.
    Please do not remove this until Pages has been re-written.
   */
  ${({
  pagesStyling
}) => pagesStyling && (0, _styledComponents.css)`
      ${_content.default} {
        padding: 0;
        margin-top: -25px;
      }

      ${_iconButton.default} {
        margin: 0;
        position: absolute;
        right: 33px;
        top: 32px;
        z-index: 1;
      }

      ${_fullScreenHeading.default} {
        padding: 32px 32px 0;
      }

      ${_heading.StyledHeading} {
        width: auto;
        padding-top: 4px;

        ${_heading.StyledHeader} {
          margin: 0 0 0 3px;
          box-sizing: content-box;
          width: 100%;
        }
      }
    `}
`;
StyledDialogFullScreen.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledDialogFullScreen;