"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DialogFullScreen = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _modal = _interopRequireDefault(require("../modal"));
var _heading = _interopRequireDefault(require("../heading"));
var _fullScreenHeading = _interopRequireDefault(require("../../__internal__/full-screen-heading"));
var _dialogFullScreen = _interopRequireDefault(require("./dialog-full-screen.style"));
var _content = _interopRequireDefault(require("./content.style"));
var _focusTrap = _interopRequireDefault(require("../../__internal__/focus-trap"));
var _iconButton = _interopRequireDefault(require("../icon-button"));
var _icon = _interopRequireDefault(require("../icon"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _useIsStickyFooterForm = _interopRequireDefault(require("../../hooks/__internal__/useIsStickyFooterForm"));
var _useModalAria = _interopRequireDefault(require("../../hooks/__internal__/useModalAria/useModalAria"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const DialogFullScreen = ({
  "aria-describedby": ariaDescribedBy,
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledBy,
  disableAutoFocus = false,
  focusFirstElement,
  bespokeFocusTrap,
  open,
  children,
  title,
  subtitle,
  pagesStyling,
  headerChildren,
  showCloseIcon = true,
  disableContentPadding,
  disableEscKey,
  onCancel,
  contentRef,
  help,
  role = "dialog",
  focusableContainers,
  focusableSelectors,
  topModalOverride,
  closeButtonDataProps,
  ...rest
}) => {
  const locale = (0, _useLocale.default)();
  const dialogRef = (0, _react.useRef)(null);
  const headingRef = (0, _react.useRef)(null);
  const {
    current: titleId
  } = (0, _react.useRef)((0, _guid.default)());
  const {
    current: subtitleId
  } = (0, _react.useRef)((0, _guid.default)());
  const hasStickyFooter = (0, _useIsStickyFooterForm.default)(children);
  const isTopModal = (0, _useModalAria.default)(dialogRef);
  const closeIcon = () => {
    if (!showCloseIcon || !onCancel) return null;
    return /*#__PURE__*/_react.default.createElement(_iconButton.default, _extends({
      "aria-label": locale.dialogFullScreen.ariaLabels.close(),
      onClick: onCancel
    }, (0, _tags.default)("close", {
      "data-element": "close",
      ...closeButtonDataProps
    })), /*#__PURE__*/_react.default.createElement(_icon.default, {
      type: "close"
    }));
  };
  const dialogTitle = () => /*#__PURE__*/_react.default.createElement(_fullScreenHeading.default, {
    hasContent: !!title,
    ref: headingRef
  }, typeof title === "string" ? /*#__PURE__*/_react.default.createElement(_heading.default, {
    "data-element": "dialog-title",
    title: title,
    titleId: titleId,
    subheader: subtitle,
    subtitleId: subtitleId,
    divider: false,
    help: help
  }) : title, headerChildren);
  const ariaProps = {
    "aria-labelledby": title && typeof title === "string" ? titleId : ariaLabelledBy,
    "aria-describedby": subtitle && typeof subtitle === "string" ? subtitleId : ariaDescribedBy,
    "aria-label": ariaLabel
  };
  const componentTags = {
    "data-component": "dialog-full-screen",
    "data-element": rest["data-element"],
    "data-role": rest["data-role"]
  };
  return /*#__PURE__*/_react.default.createElement(_modal.default, _extends({
    open: open,
    onCancel: onCancel,
    disableEscKey: disableEscKey,
    topModalOverride: topModalOverride
  }, componentTags), /*#__PURE__*/_react.default.createElement(_focusTrap.default, {
    autoFocus: !disableAutoFocus,
    focusFirstElement: focusFirstElement,
    bespokeTrap: bespokeFocusTrap,
    wrapperRef: dialogRef,
    isOpen: open,
    additionalWrapperRefs: focusableContainers,
    focusableSelectors: focusableSelectors
  }, /*#__PURE__*/_react.default.createElement(_dialogFullScreen.default, _extends({
    "aria-modal": role === "dialog" && isTopModal ? true : undefined
  }, ariaProps, {
    ref: dialogRef,
    "data-element": "dialog-full-screen",
    pagesStyling: pagesStyling,
    role: role
  }), dialogTitle(), closeIcon(), /*#__PURE__*/_react.default.createElement(_content.default, {
    hasHeader: title !== undefined,
    "data-element": "content",
    ref: contentRef,
    disableContentPadding: disableContentPadding,
    hasStickyFooter: hasStickyFooter
  }, children))));
};
exports.DialogFullScreen = DialogFullScreen;
var _default = exports.default = DialogFullScreen;