import React from "react";
import { ModalProps } from "../modal";
import { CustomRefObject } from "../../__internal__/focus-trap";
import { TagProps } from "../../__internal__/utils/helpers/tags";
export interface DialogFullScreenProps extends ModalProps {
    /** Prop to specify the aria-describedby property of the DialogFullscreen component */
    "aria-describedby"?: string;
    /**
     * Prop to specify the aria-label of the DialogFullscreen component.
     * To be used only when the title prop is not defined, and the component is not labelled by any internal element.
     */
    "aria-label"?: string;
    /**
     * Prop to specify the aria-labelledby property of the DialogFullscreen component
     * To be used when the title prop is a custom React Node,
     * or the component is labelled by an internal element other than the title.
     */
    "aria-labelledby"?: string;
    /** Child elements */
    children?: React.ReactNode;
    /** Reference to the scrollable content element */
    contentRef?: React.ForwardedRef<HTMLDivElement>;
    /** Disables auto focus functionality on child elements */
    disableAutoFocus?: boolean;
    /** remove padding from content */
    disableContentPadding?: boolean;
    /** Optional reference to an element meant to be focused on open */
    focusFirstElement?: CustomRefObject<HTMLElement> | HTMLElement | null;
    /**
     * Function to replace focus trap
     * @ignore
     * @private
     */
    bespokeFocusTrap?: (ev: KeyboardEvent, firstElement?: HTMLElement, lastElement?: HTMLElement) => void;
    /** Container for components to be displayed in the header */
    headerChildren?: React.ReactNode;
    /** Adds Help tooltip to Header */
    help?: string;
    /** For legacy styling when used with Pages component. Do not use this unless using Pages within a DialogFullScreen */
    pagesStyling?: boolean;
    /** Determines if the close icon is shown */
    showCloseIcon?: boolean;
    /** Data tag prop bag for close Button */
    closeButtonDataProps?: Pick<TagProps, "data-role" | "data-element">;
    /** Subtitle displayed at top of dialog. Its consumers' responsibility to set a suitable accessible name/description for the Dialog if they pass a node to subtitle prop. */
    subtitle?: React.ReactNode;
    /** Title displayed at top of dialog */
    title?: React.ReactNode;
    /** The ARIA role to be applied to the DialogFullscreen container */
    role?: string;
    /** an optional array of refs to containers whose content should also be reachable by tabbing from the dialog */
    focusableContainers?: CustomRefObject<HTMLElement>[];
    /** Optional selector to identify the focusable elements, if not provided a default selector is used */
    focusableSelectors?: string;
    /** A custom close event handler */
    onCancel?: (ev: React.KeyboardEvent<HTMLElement> | React.MouseEvent<HTMLButtonElement>) => void;
}
export declare const DialogFullScreen: ({ "aria-describedby": ariaDescribedBy, "aria-label": ariaLabel, "aria-labelledby": ariaLabelledBy, disableAutoFocus, focusFirstElement, bespokeFocusTrap, open, children, title, subtitle, pagesStyling, headerChildren, showCloseIcon, disableContentPadding, disableEscKey, onCancel, contentRef, help, role, focusableContainers, focusableSelectors, topModalOverride, closeButtonDataProps, ...rest }: DialogFullScreenProps) => React.JSX.Element;
export default DialogFullScreen;
