"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _form = require("../form/form.style");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledContent = _styledComponents.default.div`
  ${({
  hasStickyFooter
}) => !hasStickyFooter && (0, _styledComponents.css)`
      overflow-y: auto;
    `}
  padding: 0 16px;
  flex: 1;

  ${_form.StyledFormContent}.sticky {
    padding-right: 16px;
    padding-left: 16px;
    margin-right: -16px;
    margin-left: -16px;

    @media screen and (min-width: 600px) {
      padding-right: 24px;
      padding-left: 24px;
      margin-right: -24px;
      margin-left: -24px;
    }
    @media screen and (min-width: 960px) {
      padding-right: 32px;
      padding-left: 32px;
      margin-right: -32px;
      margin-left: -32px;
    }
    @media screen and (min-width: 1260px) {
      padding-right: 40px;
      padding-left: 40px;
      margin-right: -40px;
      margin-left: -40px;
    }
  }

  ${_form.StyledFormFooter}.sticky {
    padding: 16px;

    margin-right: -16px;
    margin-left: -16px;
    width: calc(100% + 32px);

    @media screen and (min-width: 600px) {
      padding: 16px 24px;
      margin-right: -24px;
      margin-left: -24px;
      width: calc(100% + 48px);
    }
    @media screen and (min-width: 960px) {
      padding: 16px 32px;
      margin-right: -32px;
      margin-left: -32px;
      width: calc(100% + 64px);
    }
    @media screen and (min-width: 1260px) {
      padding: 16px 40px;
      margin-right: -40px;
      margin-left: -40px;
      width: calc(100% + 80px);
    }
  }

  ${({
  disableContentPadding
}) => (0, _styledComponents.css)`
    ${!disableContentPadding && (0, _styledComponents.css)`
      @media screen and (min-width: 600px) {
        padding: 0 24px;
      }
      @media screen and (min-width: 960px) {
        padding: 0 32px;
      }
      @media screen and (min-width: 1260px) {
        padding: 0 40px;
      }
    `}

    ${disableContentPadding && (0, _styledComponents.css)`
      padding: 0;
    `}
  `}

  ${({
  hasHeader
}) => !hasHeader && (0, _styledComponents.css)`
      padding-top: 0;
      margin-top: -25px;
    `}
`;
var _default = exports.default = StyledContent;