"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledDetailIcon = exports.StyledDetailFootnote = exports.StyledDetailContent = exports.StyledDetail = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _themes = require("../../style/themes");
var _icon = _interopRequireDefault(require("../icon"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const iconSize = "16px";
const StyledDetail = exports.StyledDetail = _styledComponents.default.div`
  position: relative;
  ${_styledSystem.margin};

  + & {
    margin-top: 20px;
  }
`;
const StyledDetailContent = exports.StyledDetailContent = _styledComponents.default.div`
  ${({
  hasIcon
}) => (0, _styledComponents.css)`
    display: inline-block;
    line-height: 18px;
    white-space: pre-wrap;
    text-overflow: ellipsis;
    overflow: hidden;

    ${hasIcon && (0, _styledComponents.css)`
      margin-left: 26px;
    `}
  `}
`;
const StyledDetailIcon = exports.StyledDetailIcon = (0, _styledComponents.default)(_icon.default)`
  position: absolute;
  color: var(--colorsUtilityYin065);
  height: ${iconSize};
  width: ${iconSize};
  top: -1px;
  vertical-align: top;

  // StyledSvgIcon
  span {
    height: ${iconSize};
    width: ${iconSize};
    vertical-align: middle;
  }
`;
const StyledDetailFootnote = exports.StyledDetailFootnote = _styledComponents.default.div`
  ${({
  hasIcon
}) => (0, _styledComponents.css)`
    color: var(--colorsUtilityYin055);
    font-size: 13px;
    position: relative;
    margin-top: -2px;

    ${hasIcon && (0, _styledComponents.css)`
      margin-left: 26px;
    `}
  `}
`;
StyledDetail.defaultProps = {
  theme: _themes.baseTheme
};