"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledDt = exports.StyledDl = exports.StyledDd = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _button = _interopRequireDefault(require("../button/button.style"));
var _themes = require("../../style/themes");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledDl = exports.StyledDl = _styledComponents.default.dl`
  ${_styledSystem.space}

  ${({
  asSingleColumn,
  w
}) => (0, _styledComponents.css)`
    ${!asSingleColumn && (0, _styledComponents.css)`
      display: grid;
      grid-template-rows: auto;
      grid-template-columns: ${w}% auto;
    `}
    ${asSingleColumn && (0, _styledComponents.css)`
      line-height: 21px;
    `}
  `}

  width: 100%;
  height: auto;
  background-color: transparent;
`;
StyledDl.defaultProps = {
  theme: _themes.baseTheme
};
const StyledDt = exports.StyledDt = _styledComponents.default.dt`
  ${_styledSystem.space}
  font-size: var(--fontSizes100);
  font-weight: 700;
  color: var(--colorsUtilityYin090);
  ${({
  asSingleColumn
}) => !asSingleColumn && (0, _styledComponents.css)`
      grid-column: 1;
    `}
  ${({
  dtTextAlign
}) => (0, _styledComponents.css)`
    text-align: ${dtTextAlign};
  `}
`;
StyledDt.defaultProps = {
  theme: _themes.baseTheme
};
const StyledDd = exports.StyledDd = _styledComponents.default.dd`
  font-size: var(--fontSizes100);
  font-weight: var(--fontWeights400);
  color: var(--colorsUtilityYin065);
  margin-left: 0px;
  ${({
  asSingleColumn
}) => !asSingleColumn && (0, _styledComponents.css)`
      grid-column: 2;
    `}
  ${({
  ddTextAlign
}) => (0, _styledComponents.css)`
    text-align: ${ddTextAlign};
  `}

  ${_button.default} {
    padding: 0;
    border: none;
  }
  ${_styledSystem.space}
`;