"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _input = _interopRequireDefault(require("../../__internal__/input/input.style"));
var _inputPresentation = _interopRequireDefault(require("../../__internal__/input/input-presentation.style"));
var _formField = require("../../__internal__/form-field/form-field.style");
var _validationMessage = _interopRequireDefault(require("../../__internal__/validation-message/validation-message.style"));
var _label = _interopRequireDefault(require("../../__internal__/label/label.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const datePickerWidth = {
  large: "140px",
  medium: "135px",
  small: "120px"
};
const StyledDateInput = _styledComponents.default.div`
  ${_styledSystem.margin}

  & ${_inputPresentation.default} {
    flex: none;
    width: ${({
  inputWidth,
  maxWidth,
  size = "medium"
}) => maxWidth || inputWidth ? "" : datePickerWidth[size]};

    ${_input.default} {
      margin-right: -8px;
    }
  }

  ${({
  applyDateRangeStyling,
  maxWidth,
  size = "medium",
  labelInline
}) => applyDateRangeStyling && !labelInline && (0, _styledComponents.css)`
      ${_formField.FieldLineStyle} {
        max-width: ${maxWidth || datePickerWidth[size]}};
      }

      ${_validationMessage.default}, ${_label.default} {
        overflow-wrap: anywhere;
      }
    `}
`;
StyledDateInput.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledDateInput;