"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DateInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("./__internal__/utils");
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events"));
var _utils2 = require("../../style/utils");
var _dateFormats = _interopRequireDefault(require("./__internal__/date-formats"));
var _date = _interopRequireDefault(require("./date.style"));
var _textbox = _interopRequireDefault(require("../textbox"));
var _datePicker = _interopRequireDefault(require("./__internal__/date-picker"));
var _dateRange = _interopRequireDefault(require("../date-range/date-range.context"));
var _useClickAwayListener = _interopRequireDefault(require("../../hooks/__internal__/useClickAwayListener"));
var _useFormSpacing = _interopRequireDefault(require("../../hooks/__internal__/useFormSpacing"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const DateInput = exports.DateInput = /*#__PURE__*/_react.default.forwardRef(({
  adaptiveLabelBreakpoint,
  allowEmptyValue,
  autoFocus,
  "data-component": dataComponent,
  "data-element": dataElement,
  "data-role": dataRole,
  disabled,
  disablePortal = false,
  helpAriaLabel,
  labelInline,
  minDate,
  maxDate,
  onBlur,
  onChange,
  onClick,
  onFocus,
  onKeyDown,
  pickerProps = {},
  readOnly,
  size = "medium",
  tooltipPosition,
  value,
  inputWidth,
  labelWidth,
  maxWidth,
  inputName,
  ...rest
}, ref) => {
  const wrapperRef = (0, _react.useRef)(null);
  const parentRef = (0, _react.useRef)(null);
  const internalInputRef = (0, _react.useRef)(null);
  const alreadyFocused = (0, _react.useRef)(false);
  const isBlurBlocked = (0, _react.useRef)(false);
  const focusedViaPicker = (0, _react.useRef)(false);
  const l = (0, _useLocale.default)();
  const {
    dateFnsLocale
  } = l.date;
  const {
    format,
    formats
  } = (0, _react.useMemo)(() => (0, _dateFormats.default)(dateFnsLocale()), [dateFnsLocale]);
  const {
    inputRefMap,
    setInputRefMap
  } = (0, _react.useContext)(_dateRange.default);
  const [open, setOpen] = (0, _react.useState)(false);
  const [selectedDays, setSelectedDays] = (0, _react.useState)((0, _utils.checkISOFormatAndLength)(value) ? (0, _utils.parseISODate)(value) : (0, _utils.parseDate)(format, value));
  const isInitialValue = (0, _react.useRef)(true);
  const pickerTabGuardId = (0, _react.useRef)((0, _guid.default)());
  const computeInvalidRawValue = inputValue => allowEmptyValue && !inputValue.length ? inputValue : null;
  const buildCustomEvent = ev => {
    const {
      id,
      name
    } = ev.target;
    const [matchedFormat, matchedValue] = (0, _utils.findMatchedFormatAndValue)(ev.target.value, formats);
    const formattedValueString = ev.type === "blur" ? (0, _utils.formattedValue)(format, selectedDays) : ev.target.value;
    const rawValue = (0, _utils.isDateValid)((0, _utils.parseDate)(matchedFormat, matchedValue)) ? (0, _utils.formatToISO)(...(0, _utils.additionalYears)(matchedFormat, matchedValue)) : computeInvalidRawValue(ev.target.value);
    const customEvent = {
      target: {
        ...(name && {
          name
        }),
        ...(id && {
          id
        }),
        value: {
          formattedValue: formattedValueString,
          rawValue
        }
      }
    };
    return customEvent;
  };
  const handleClickAway = () => {
    if (open) {
      alreadyFocused.current = true;
      internalInputRef.current?.focus();
      isBlurBlocked.current = false;
      internalInputRef.current?.blur();
      setOpen(false);
      alreadyFocused.current = false;
    }
  };
  const handleClickInside = (0, _useClickAwayListener.default)(handleClickAway, "mousedown");
  const handleChange = ev => {
    isInitialValue.current = false;
    onChange(buildCustomEvent(ev));
  };
  const focusInput = () => {
    focusedViaPicker.current = true;
    internalInputRef.current?.focus();
  };
  const handleDayClick = (day, ev) => {
    setSelectedDays(day);
    onChange(buildCustomEvent({
      ...ev,
      target: {
        ...ev.target,
        value: (0, _utils.formattedValue)(format, day)
      }
    }));
    focusInput();
    setOpen(false);
  };
  const handleBlur = ev => {
    if (disabled || readOnly) {
      return;
    }
    let event;
    if ((0, _utils.isDateValid)(selectedDays)) {
      event = buildCustomEvent(ev);
      const currentValue = (0, _utils.checkISOFormatAndLength)(value) ? (0, _utils.formattedValue)(format, (0, _utils.parseISODate)(value)) : value;
      const [, matchedValue] = (0, _utils.findMatchedFormatAndValue)(currentValue, formats);
      if ((0, _utils.formattedValue)(format, selectedDays) !== matchedValue) {
        onChange(event);
      }
    } else {
      const {
        id,
        name
      } = ev.target;
      event = {
        target: {
          ...(name && {
            name
          }),
          ...(id && {
            id
          }),
          value: {
            formattedValue: ev.target.value,
            rawValue: computeInvalidRawValue(ev.target.value)
          }
        }
      };
    }
    if (isBlurBlocked.current) {
      return;
    }
    if (onBlur) {
      onBlur(event);
    }
  };
  const handleFocus = ev => {
    if (disabled || readOnly) {
      return;
    }
    isBlurBlocked.current = false;
    if (!open && !alreadyFocused.current) {
      setOpen(true);
    } else {
      alreadyFocused.current = false;
    }
    if (onFocus) {
      onFocus(ev);
    }
  };
  const handleKeyUp = (0, _react.useCallback)(ev => {
    /* istanbul ignore else */
    if (open && _events.default.isEscKey(ev)) {
      setOpen(false);
      ev.stopPropagation();
    }
  }, [open]);
  const handleKeyDown = ev => {
    if (onKeyDown) {
      onKeyDown(ev);
    }
    if (open && _events.default.isTabKey(ev)) {
      if (_events.default.isShiftKey(ev)) {
        setOpen(false);
      } else if (!disablePortal) {
        ev.preventDefault();
        document?.querySelector(`[id="${pickerTabGuardId.current}"]`)?.focus();
      }
      alreadyFocused.current = false;
    }
  };
  const handleClick = ev => {
    if (onClick) {
      onClick(ev);
    }
  };
  const handleMouseDown = ev => {
    handleClickInside();
    if (setInputRefMap) {
      isBlurBlocked.current = true;
    }
    const {
      type
    } = ev.target;
    if (type !== "text") {
      alreadyFocused.current = true;
      setOpen(prev => !prev);
    } else if (!open) {
      setOpen(true);
    }
  };
  const handleIconMouseDown = ev => {
    isBlurBlocked.current = true;
    handleMouseDown(ev);
  };
  const handlePickerMouseDown = () => {
    isBlurBlocked.current = true;
    handleClickInside();
  };
  const assignInput = (0, _react.useCallback)(inputElement => {
    internalInputRef.current = inputElement;
    parentRef.current = inputElement?.parentElement;
    if (ref) {
      if (typeof ref === "function") {
        ref(inputElement);
      } else {
        ref.current = inputElement;
      }
    }
    if (inputName && inputRefMap?.[inputName]?.setOpen !== setOpen) {
      setInputRefMap?.({
        [inputName]: {
          isBlurBlocked,
          setOpen
        }
      });
    }
  }, [inputName, inputRefMap, setInputRefMap, ref]);
  (0, _react.useEffect)(() => {
    const [matchedFormat, matchedValue] = (0, _utils.findMatchedFormatAndValue)(value, formats);
    if (matchedFormat && matchedValue && (0, _utils.isDateValid)((0, _utils.parseDate)(matchedFormat, matchedValue))) {
      setSelectedDays((0, _utils.parseDate)(...(0, _utils.additionalYears)(matchedFormat, matchedValue)));
    } else if ((0, _utils.checkISOFormatAndLength)(value) && isInitialValue.current) {
      setSelectedDays((0, _utils.parseISODate)(value));
    } else {
      setSelectedDays(undefined);
    }
  }, [value, formats]);
  const computedValue = () => {
    if ((0, _utils.checkISOFormatAndLength)(value) && isInitialValue.current) {
      return (0, _utils.formattedValue)(format, (0, _utils.parseISODate)(value));
    }
    const valueSeparator = (0, _utils.getSeparator)(value);
    const formatSeparator = (0, _utils.getSeparator)(format);
    const replaceSeparators = () => value.split("").map(char => char === valueSeparator ? formatSeparator : char).join("");
    if (isInitialValue.current && valueSeparator !== formatSeparator && (0, _utils.isDateValid)((0, _utils.parseDate)(format, replaceSeparators()))) {
      isInitialValue.current = false;
      const [matchedFormat, matchedValue] = (0, _utils.findMatchedFormatAndValue)(replaceSeparators(), formats);
      return (0, _utils.formattedValue)(format, (0, _utils.parseDate)(...(0, _utils.additionalYears)(matchedFormat, matchedValue)));
    }
    return value;
  };
  const marginProps = (0, _useFormSpacing.default)(rest);
  return /*#__PURE__*/_react.default.createElement(_date.default, _extends({
    ref: wrapperRef,
    role: "presentation",
    size: size,
    labelInline: labelInline,
    "data-component": dataComponent || "date",
    "data-element": dataElement,
    "data-role": dataRole
  }, marginProps, {
    applyDateRangeStyling: !!inputRefMap,
    maxWidth: maxWidth,
    inputWidth: inputWidth
  }), /*#__PURE__*/_react.default.createElement(_textbox.default, _extends({}, (0, _utils2.filterOutStyledSystemSpacingProps)(rest), {
    value: computedValue(),
    onBlur: handleBlur,
    onChange: handleChange,
    onClick: handleClick,
    onFocus: handleFocus,
    onKeyUp: handleKeyUp,
    onKeyDown: handleKeyDown,
    iconOnClick: handleClick,
    onMouseDown: handleMouseDown,
    iconOnMouseDown: handleIconMouseDown,
    inputIcon: "calendar",
    labelInline: labelInline,
    ref: assignInput,
    adaptiveLabelBreakpoint: adaptiveLabelBreakpoint,
    tooltipPosition: tooltipPosition,
    helpAriaLabel: helpAriaLabel,
    autoFocus: autoFocus,
    size: size,
    disabled: disabled,
    readOnly: readOnly,
    inputWidth: inputWidth,
    labelWidth: labelWidth,
    maxWidth: maxWidth,
    m: 0
  })), /*#__PURE__*/_react.default.createElement(_datePicker.default, {
    disablePortal: disablePortal,
    inputElement: parentRef,
    pickerProps: pickerProps,
    selectedDays: selectedDays,
    onDayClick: handleDayClick,
    minDate: minDate,
    maxDate: maxDate,
    pickerMouseDown: handlePickerMouseDown,
    open: open,
    setOpen: setOpen,
    pickerTabGuardId: pickerTabGuardId.current
  }));
});
if (process.env.NODE_ENV !== "production") {
  DateInput.propTypes = {
    "about": _propTypes.default.string,
    "accept": _propTypes.default.string,
    "accessKey": _propTypes.default.string,
    "adaptiveLabelBreakpoint": _propTypes.default.number,
    "align": _propTypes.default.oneOf(["left", "right"]),
    "allowEmptyValue": _propTypes.default.bool,
    "alt": _propTypes.default.string,
    "aria-activedescendant": _propTypes.default.string,
    "aria-atomic": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-autocomplete": _propTypes.default.oneOf(["both", "inline", "list", "none"]),
    "aria-busy": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-checked": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "mixed", "true"]), _propTypes.default.bool]),
    "aria-colcount": _propTypes.default.number,
    "aria-colindex": _propTypes.default.number,
    "aria-colspan": _propTypes.default.number,
    "aria-controls": _propTypes.default.string,
    "aria-current": _propTypes.default.oneOfType([_propTypes.default.oneOf(["date", "false", "location", "page", "step", "time", "true"]), _propTypes.default.bool]),
    "aria-describedby": _propTypes.default.string,
    "aria-details": _propTypes.default.string,
    "aria-disabled": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-dropeffect": _propTypes.default.oneOf(["copy", "execute", "link", "move", "none", "popup"]),
    "aria-errormessage": _propTypes.default.string,
    "aria-expanded": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-flowto": _propTypes.default.string,
    "aria-grabbed": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-haspopup": _propTypes.default.oneOfType([_propTypes.default.oneOf(["dialog", "false", "grid", "listbox", "menu", "tree", "true"]), _propTypes.default.bool]),
    "aria-hidden": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-invalid": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "grammar", "spelling", "true"]), _propTypes.default.bool]),
    "aria-keyshortcuts": _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "aria-labelledby": _propTypes.default.string,
    "aria-level": _propTypes.default.number,
    "aria-live": _propTypes.default.oneOf(["assertive", "off", "polite"]),
    "aria-modal": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-multiline": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-multiselectable": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-orientation": _propTypes.default.oneOf(["horizontal", "vertical"]),
    "aria-owns": _propTypes.default.string,
    "aria-placeholder": _propTypes.default.string,
    "aria-posinset": _propTypes.default.number,
    "aria-pressed": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "mixed", "true"]), _propTypes.default.bool]),
    "aria-readonly": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-relevant": _propTypes.default.oneOf(["additions removals", "additions text", "additions", "all", "removals additions", "removals text", "removals", "text additions", "text removals", "text"]),
    "aria-required": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-roledescription": _propTypes.default.string,
    "aria-rowcount": _propTypes.default.number,
    "aria-rowindex": _propTypes.default.number,
    "aria-rowspan": _propTypes.default.number,
    "aria-selected": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-setsize": _propTypes.default.number,
    "aria-sort": _propTypes.default.oneOf(["ascending", "descending", "none", "other"]),
    "aria-valuemax": _propTypes.default.number,
    "aria-valuemin": _propTypes.default.number,
    "aria-valuenow": _propTypes.default.number,
    "aria-valuetext": _propTypes.default.string,
    "ariaDescribedBy": _propTypes.default.string,
    "as": _propTypes.default.elementType,
    "autoCapitalize": _propTypes.default.string,
    "autoComplete": _propTypes.default.string,
    "autoCorrect": _propTypes.default.string,
    "autoFocus": _propTypes.default.bool,
    "autoSave": _propTypes.default.string,
    "capture": _propTypes.default.oneOfType([_propTypes.default.oneOf(["environment", "user"]), _propTypes.default.bool]),
    "checked": _propTypes.default.bool,
    "className": _propTypes.default.string,
    "color": _propTypes.default.string,
    "content": _propTypes.default.string,
    "contentEditable": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "inherit", "true"]), _propTypes.default.bool]),
    "contextMenu": _propTypes.default.string,
    "dangerouslySetInnerHTML": _propTypes.default.shape({
      "__html": _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string]).isRequired
    }),
    "data-component": _propTypes.default.string,
    "data-element": _propTypes.default.string,
    "data-role": _propTypes.default.string,
    "datatype": _propTypes.default.string,
    "defaultChecked": _propTypes.default.bool,
    "defaultValue": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.string), _propTypes.default.number, _propTypes.default.string]),
    "dir": _propTypes.default.string,
    "disabled": _propTypes.default.bool,
    "disablePortal": _propTypes.default.bool,
    "draggable": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "enterKeyHint": _propTypes.default.oneOf(["done", "enter", "go", "next", "previous", "search", "send"]),
    "error": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "fieldHelp": _propTypes.default.node,
    "form": _propTypes.default.string,
    "formAction": _propTypes.default.string,
    "formEncType": _propTypes.default.string,
    "formMethod": _propTypes.default.string,
    "formNoValidate": _propTypes.default.bool,
    "formTarget": _propTypes.default.string,
    "height": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "helpAriaLabel": _propTypes.default.string,
    "hidden": _propTypes.default.bool,
    "id": _propTypes.default.string,
    "info": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "inlist": _propTypes.default.any,
    "inputHint": _propTypes.default.string,
    "inputMode": _propTypes.default.oneOf(["decimal", "email", "none", "numeric", "search", "tel", "text", "url"]),
    "inputName": _propTypes.default.oneOf(["end", "start"]),
    "inputWidth": _propTypes.default.number,
    "is": _propTypes.default.string,
    "isOptional": _propTypes.default.bool,
    "itemID": _propTypes.default.string,
    "itemProp": _propTypes.default.string,
    "itemRef": _propTypes.default.string,
    "itemScope": _propTypes.default.bool,
    "itemType": _propTypes.default.string,
    "label": _propTypes.default.string,
    "labelAlign": _propTypes.default.oneOf(["left", "right"]),
    "labelHelp": _propTypes.default.node,
    "labelInline": _propTypes.default.bool,
    "labelSpacing": _propTypes.default.oneOf([1, 2]),
    "labelWidth": _propTypes.default.number,
    "lang": _propTypes.default.string,
    "list": _propTypes.default.string,
    "m": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "margin": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "max": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "maxDate": _propTypes.default.string,
    "maxLength": _propTypes.default.number,
    "maxWidth": _propTypes.default.string,
    "mb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "min": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "minDate": _propTypes.default.string,
    "minLength": _propTypes.default.number,
    "ml": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "multiple": _propTypes.default.bool,
    "mx": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "my": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "name": _propTypes.default.string,
    "nonce": _propTypes.default.string,
    "onAbort": _propTypes.default.func,
    "onAbortCapture": _propTypes.default.func,
    "onAnimationEnd": _propTypes.default.func,
    "onAnimationEndCapture": _propTypes.default.func,
    "onAnimationIteration": _propTypes.default.func,
    "onAnimationIterationCapture": _propTypes.default.func,
    "onAnimationStart": _propTypes.default.func,
    "onAnimationStartCapture": _propTypes.default.func,
    "onAuxClick": _propTypes.default.func,
    "onAuxClickCapture": _propTypes.default.func,
    "onBeforeInput": _propTypes.default.func,
    "onBeforeInputCapture": _propTypes.default.func,
    "onBlur": _propTypes.default.func,
    "onBlurCapture": _propTypes.default.func,
    "onCanPlay": _propTypes.default.func,
    "onCanPlayCapture": _propTypes.default.func,
    "onCanPlayThrough": _propTypes.default.func,
    "onCanPlayThroughCapture": _propTypes.default.func,
    "onChange": _propTypes.default.func.isRequired,
    "onChangeCapture": _propTypes.default.func,
    "onClick": _propTypes.default.func,
    "onClickCapture": _propTypes.default.func,
    "onCompositionEnd": _propTypes.default.func,
    "onCompositionEndCapture": _propTypes.default.func,
    "onCompositionStart": _propTypes.default.func,
    "onCompositionStartCapture": _propTypes.default.func,
    "onCompositionUpdate": _propTypes.default.func,
    "onCompositionUpdateCapture": _propTypes.default.func,
    "onContextMenu": _propTypes.default.func,
    "onContextMenuCapture": _propTypes.default.func,
    "onCopy": _propTypes.default.func,
    "onCopyCapture": _propTypes.default.func,
    "onCut": _propTypes.default.func,
    "onCutCapture": _propTypes.default.func,
    "onDoubleClick": _propTypes.default.func,
    "onDoubleClickCapture": _propTypes.default.func,
    "onDrag": _propTypes.default.func,
    "onDragCapture": _propTypes.default.func,
    "onDragEnd": _propTypes.default.func,
    "onDragEndCapture": _propTypes.default.func,
    "onDragEnter": _propTypes.default.func,
    "onDragEnterCapture": _propTypes.default.func,
    "onDragExit": _propTypes.default.func,
    "onDragExitCapture": _propTypes.default.func,
    "onDragLeave": _propTypes.default.func,
    "onDragLeaveCapture": _propTypes.default.func,
    "onDragOver": _propTypes.default.func,
    "onDragOverCapture": _propTypes.default.func,
    "onDragStart": _propTypes.default.func,
    "onDragStartCapture": _propTypes.default.func,
    "onDrop": _propTypes.default.func,
    "onDropCapture": _propTypes.default.func,
    "onDurationChange": _propTypes.default.func,
    "onDurationChangeCapture": _propTypes.default.func,
    "onEmptied": _propTypes.default.func,
    "onEmptiedCapture": _propTypes.default.func,
    "onEncrypted": _propTypes.default.func,
    "onEncryptedCapture": _propTypes.default.func,
    "onEnded": _propTypes.default.func,
    "onEndedCapture": _propTypes.default.func,
    "onError": _propTypes.default.func,
    "onErrorCapture": _propTypes.default.func,
    "onFocus": _propTypes.default.func,
    "onFocusCapture": _propTypes.default.func,
    "onGotPointerCapture": _propTypes.default.func,
    "onGotPointerCaptureCapture": _propTypes.default.func,
    "onInput": _propTypes.default.func,
    "onInputCapture": _propTypes.default.func,
    "onInvalid": _propTypes.default.func,
    "onInvalidCapture": _propTypes.default.func,
    "onKeyDown": _propTypes.default.func,
    "onKeyDownCapture": _propTypes.default.func,
    "onKeyPress": _propTypes.default.func,
    "onKeyPressCapture": _propTypes.default.func,
    "onKeyUp": _propTypes.default.func,
    "onKeyUpCapture": _propTypes.default.func,
    "onLoad": _propTypes.default.func,
    "onLoadCapture": _propTypes.default.func,
    "onLoadedData": _propTypes.default.func,
    "onLoadedDataCapture": _propTypes.default.func,
    "onLoadedMetadata": _propTypes.default.func,
    "onLoadedMetadataCapture": _propTypes.default.func,
    "onLoadStart": _propTypes.default.func,
    "onLoadStartCapture": _propTypes.default.func,
    "onLostPointerCapture": _propTypes.default.func,
    "onLostPointerCaptureCapture": _propTypes.default.func,
    "onMouseDownCapture": _propTypes.default.func,
    "onMouseEnter": _propTypes.default.func,
    "onMouseLeave": _propTypes.default.func,
    "onMouseMove": _propTypes.default.func,
    "onMouseMoveCapture": _propTypes.default.func,
    "onMouseOut": _propTypes.default.func,
    "onMouseOutCapture": _propTypes.default.func,
    "onMouseOver": _propTypes.default.func,
    "onMouseOverCapture": _propTypes.default.func,
    "onMouseUp": _propTypes.default.func,
    "onMouseUpCapture": _propTypes.default.func,
    "onPaste": _propTypes.default.func,
    "onPasteCapture": _propTypes.default.func,
    "onPause": _propTypes.default.func,
    "onPauseCapture": _propTypes.default.func,
    "onPlay": _propTypes.default.func,
    "onPlayCapture": _propTypes.default.func,
    "onPlaying": _propTypes.default.func,
    "onPlayingCapture": _propTypes.default.func,
    "onPointerCancel": _propTypes.default.func,
    "onPointerCancelCapture": _propTypes.default.func,
    "onPointerDown": _propTypes.default.func,
    "onPointerDownCapture": _propTypes.default.func,
    "onPointerEnter": _propTypes.default.func,
    "onPointerEnterCapture": _propTypes.default.func,
    "onPointerLeave": _propTypes.default.func,
    "onPointerLeaveCapture": _propTypes.default.func,
    "onPointerMove": _propTypes.default.func,
    "onPointerMoveCapture": _propTypes.default.func,
    "onPointerOut": _propTypes.default.func,
    "onPointerOutCapture": _propTypes.default.func,
    "onPointerOver": _propTypes.default.func,
    "onPointerOverCapture": _propTypes.default.func,
    "onPointerUp": _propTypes.default.func,
    "onPointerUpCapture": _propTypes.default.func,
    "onProgress": _propTypes.default.func,
    "onProgressCapture": _propTypes.default.func,
    "onRateChange": _propTypes.default.func,
    "onRateChangeCapture": _propTypes.default.func,
    "onReset": _propTypes.default.func,
    "onResetCapture": _propTypes.default.func,
    "onScroll": _propTypes.default.func,
    "onScrollCapture": _propTypes.default.func,
    "onSeeked": _propTypes.default.func,
    "onSeekedCapture": _propTypes.default.func,
    "onSeeking": _propTypes.default.func,
    "onSeekingCapture": _propTypes.default.func,
    "onSelect": _propTypes.default.func,
    "onSelectCapture": _propTypes.default.func,
    "onStalled": _propTypes.default.func,
    "onStalledCapture": _propTypes.default.func,
    "onSubmit": _propTypes.default.func,
    "onSubmitCapture": _propTypes.default.func,
    "onSuspend": _propTypes.default.func,
    "onSuspendCapture": _propTypes.default.func,
    "onTimeUpdate": _propTypes.default.func,
    "onTimeUpdateCapture": _propTypes.default.func,
    "onTouchCancel": _propTypes.default.func,
    "onTouchCancelCapture": _propTypes.default.func,
    "onTouchEnd": _propTypes.default.func,
    "onTouchEndCapture": _propTypes.default.func,
    "onTouchMove": _propTypes.default.func,
    "onTouchMoveCapture": _propTypes.default.func,
    "onTouchStart": _propTypes.default.func,
    "onTouchStartCapture": _propTypes.default.func,
    "onTransitionEnd": _propTypes.default.func,
    "onTransitionEndCapture": _propTypes.default.func,
    "onVolumeChange": _propTypes.default.func,
    "onVolumeChangeCapture": _propTypes.default.func,
    "onWaiting": _propTypes.default.func,
    "onWaitingCapture": _propTypes.default.func,
    "onWheel": _propTypes.default.func,
    "onWheelCapture": _propTypes.default.func,
    "pattern": _propTypes.default.string,
    "pickerProps": _propTypes.default.shape({
      "canChangeMonth": _propTypes.default.bool,
      "captionElement": _propTypes.default.oneOfType([_propTypes.default.element, _propTypes.default.func, _propTypes.default.shape({
        "childContextTypes": _propTypes.default.object,
        "contextType": _propTypes.default.shape({
          "Consumer": _propTypes.default.func.isRequired,
          "displayName": _propTypes.default.string,
          "Provider": _propTypes.default.func.isRequired
        }),
        "contextTypes": _propTypes.default.object,
        "defaultProps": _propTypes.default.shape({
          "classNames": _propTypes.default.object,
          "date": _propTypes.default.instanceOf(Date),
          "locale": _propTypes.default.string,
          "localeUtils": _propTypes.default.object,
          "months": _propTypes.default.arrayOf(_propTypes.default.string),
          "onClick": _propTypes.default.func
        }),
        "displayName": _propTypes.default.string,
        "getDerivedStateFromError": _propTypes.default.func,
        "getDerivedStateFromProps": _propTypes.default.func,
        "propTypes": _propTypes.default.shape({
          "classNames": _propTypes.default.func,
          "date": _propTypes.default.func,
          "locale": _propTypes.default.func,
          "localeUtils": _propTypes.default.func,
          "months": _propTypes.default.func,
          "onClick": _propTypes.default.func
        })
      })]),
      "className": _propTypes.default.string,
      "classNames": _propTypes.default.shape({
        "body": _propTypes.default.string.isRequired,
        "caption": _propTypes.default.string.isRequired,
        "container": _propTypes.default.string.isRequired,
        "day": _propTypes.default.string.isRequired,
        "disabled": _propTypes.default.string.isRequired,
        "footer": _propTypes.default.string.isRequired,
        "interactionDisabled": _propTypes.default.string.isRequired,
        "month": _propTypes.default.string.isRequired,
        "months": _propTypes.default.string.isRequired,
        "navBar": _propTypes.default.string.isRequired,
        "navButtonInteractionDisabled": _propTypes.default.string.isRequired,
        "navButtonNext": _propTypes.default.string.isRequired,
        "navButtonPrev": _propTypes.default.string.isRequired,
        "outside": _propTypes.default.string.isRequired,
        "selected": _propTypes.default.string.isRequired,
        "today": _propTypes.default.string.isRequired,
        "todayButton": _propTypes.default.string.isRequired,
        "week": _propTypes.default.string.isRequired,
        "weekday": _propTypes.default.string.isRequired,
        "weekdays": _propTypes.default.string.isRequired,
        "weekdaysRow": _propTypes.default.string.isRequired,
        "weekNumber": _propTypes.default.string.isRequired,
        "wrapper": _propTypes.default.string.isRequired
      }),
      "containerProps": _propTypes.default.object,
      "dir": _propTypes.default.string,
      "disabledDays": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.instanceOf(Date), _propTypes.default.shape({
        "from": _propTypes.default.instanceOf(Date),
        "to": _propTypes.default.instanceOf(Date)
      })])), _propTypes.default.func, _propTypes.default.instanceOf(Date), _propTypes.default.shape({
        "from": _propTypes.default.instanceOf(Date),
        "to": _propTypes.default.instanceOf(Date)
      })]),
      "enableOutsideDaysClick": _propTypes.default.bool,
      "firstDayOfWeek": _propTypes.default.number,
      "fixedWeeks": _propTypes.default.bool,
      "fromMonth": _propTypes.default.instanceOf(Date),
      "initialMonth": _propTypes.default.instanceOf(Date),
      "labels": _propTypes.default.shape({
        "nextMonth": _propTypes.default.string.isRequired,
        "previousMonth": _propTypes.default.string.isRequired
      }),
      "locale": _propTypes.default.string,
      "localeUtils": _propTypes.default.shape({
        "formatDate": _propTypes.default.func.isRequired,
        "formatDay": _propTypes.default.func.isRequired,
        "formatMonthTitle": _propTypes.default.func.isRequired,
        "formatWeekdayLong": _propTypes.default.func.isRequired,
        "formatWeekdayShort": _propTypes.default.func.isRequired,
        "getFirstDayOfWeek": _propTypes.default.func.isRequired,
        "getMonths": _propTypes.default.func.isRequired,
        "parseDate": _propTypes.default.func.isRequired
      }),
      "modifiers": _propTypes.default.shape({
        "outside": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.instanceOf(Date), _propTypes.default.shape({
          "from": _propTypes.default.instanceOf(Date),
          "to": _propTypes.default.instanceOf(Date)
        })])), _propTypes.default.func, _propTypes.default.instanceOf(Date), _propTypes.default.shape({
          "from": _propTypes.default.instanceOf(Date),
          "to": _propTypes.default.instanceOf(Date)
        })]),
        "today": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.instanceOf(Date), _propTypes.default.shape({
          "from": _propTypes.default.instanceOf(Date),
          "to": _propTypes.default.instanceOf(Date)
        })])), _propTypes.default.func, _propTypes.default.instanceOf(Date), _propTypes.default.shape({
          "from": _propTypes.default.instanceOf(Date),
          "to": _propTypes.default.instanceOf(Date)
        })])
      }),
      "modifiersStyles": _propTypes.default.object,
      "month": _propTypes.default.instanceOf(Date),
      "months": _propTypes.default.arrayOf(_propTypes.default.string),
      "navbarElement": _propTypes.default.oneOfType([_propTypes.default.element, _propTypes.default.func, _propTypes.default.shape({
        "childContextTypes": _propTypes.default.object,
        "contextType": _propTypes.default.shape({
          "Consumer": _propTypes.default.func.isRequired,
          "displayName": _propTypes.default.string,
          "Provider": _propTypes.default.func.isRequired
        }),
        "contextTypes": _propTypes.default.object,
        "defaultProps": _propTypes.default.shape({
          "className": _propTypes.default.string,
          "classNames": _propTypes.default.object,
          "dir": _propTypes.default.string,
          "labels": _propTypes.default.object,
          "locale": _propTypes.default.string,
          "localeUtils": _propTypes.default.object,
          "month": _propTypes.default.instanceOf(Date),
          "nextMonth": _propTypes.default.instanceOf(Date),
          "onNextClick": _propTypes.default.func,
          "onPreviousClick": _propTypes.default.func,
          "previousMonth": _propTypes.default.instanceOf(Date),
          "showNextButton": _propTypes.default.bool,
          "showPreviousButton": _propTypes.default.bool
        }),
        "displayName": _propTypes.default.string,
        "getDerivedStateFromError": _propTypes.default.func,
        "getDerivedStateFromProps": _propTypes.default.func,
        "propTypes": _propTypes.default.shape({
          "className": _propTypes.default.func,
          "classNames": _propTypes.default.func,
          "dir": _propTypes.default.func,
          "labels": _propTypes.default.func,
          "locale": _propTypes.default.func,
          "localeUtils": _propTypes.default.func,
          "month": _propTypes.default.func,
          "nextMonth": _propTypes.default.func,
          "onNextClick": _propTypes.default.func,
          "onPreviousClick": _propTypes.default.func,
          "previousMonth": _propTypes.default.func,
          "showNextButton": _propTypes.default.func,
          "showPreviousButton": _propTypes.default.func
        })
      })]),
      "numberOfMonths": _propTypes.default.number,
      "onBlur": _propTypes.default.func,
      "onCaptionClick": _propTypes.default.func,
      "onDayClick": _propTypes.default.func,
      "onDayKeyDown": _propTypes.default.func,
      "onDayMouseDown": _propTypes.default.func,
      "onDayMouseEnter": _propTypes.default.func,
      "onDayMouseLeave": _propTypes.default.func,
      "onDayMouseUp": _propTypes.default.func,
      "onDayTouchEnd": _propTypes.default.func,
      "onDayTouchStart": _propTypes.default.func,
      "onFocus": _propTypes.default.func,
      "onKeyDown": _propTypes.default.func,
      "onMonthChange": _propTypes.default.func,
      "onTodayButtonClick": _propTypes.default.func,
      "onWeekClick": _propTypes.default.func,
      "pagedNavigation": _propTypes.default.bool,
      "renderDay": _propTypes.default.func,
      "renderWeek": _propTypes.default.func,
      "reverseMonths": _propTypes.default.bool,
      "selectedDays": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.instanceOf(Date), _propTypes.default.shape({
        "from": _propTypes.default.instanceOf(Date),
        "to": _propTypes.default.instanceOf(Date)
      })])), _propTypes.default.func, _propTypes.default.instanceOf(Date), _propTypes.default.shape({
        "from": _propTypes.default.instanceOf(Date),
        "to": _propTypes.default.instanceOf(Date)
      })]),
      "showOutsideDays": _propTypes.default.bool,
      "showWeekDays": _propTypes.default.bool,
      "showWeekNumbers": _propTypes.default.bool,
      "tabIndex": _propTypes.default.number,
      "todayButton": _propTypes.default.string,
      "toMonth": _propTypes.default.instanceOf(Date),
      "weekdayElement": _propTypes.default.oneOfType([_propTypes.default.element, _propTypes.default.func, _propTypes.default.shape({
        "childContextTypes": _propTypes.default.object,
        "contextType": _propTypes.default.shape({
          "Consumer": _propTypes.default.func.isRequired,
          "displayName": _propTypes.default.string,
          "Provider": _propTypes.default.func.isRequired
        }),
        "contextTypes": _propTypes.default.object,
        "defaultProps": _propTypes.default.shape({
          "className": _propTypes.default.string,
          "locale": _propTypes.default.string,
          "localeUtils": _propTypes.default.object,
          "weekday": _propTypes.default.number,
          "weekdaysLong": _propTypes.default.arrayOf(_propTypes.default.string),
          "weekdaysShort": _propTypes.default.arrayOf(_propTypes.default.string)
        }),
        "displayName": _propTypes.default.string,
        "getDerivedStateFromError": _propTypes.default.func,
        "getDerivedStateFromProps": _propTypes.default.func,
        "propTypes": _propTypes.default.shape({
          "className": _propTypes.default.func,
          "locale": _propTypes.default.func,
          "localeUtils": _propTypes.default.func,
          "weekday": _propTypes.default.func,
          "weekdaysLong": _propTypes.default.func,
          "weekdaysShort": _propTypes.default.func
        })
      })]),
      "weekdaysLong": _propTypes.default.arrayOf(_propTypes.default.string),
      "weekdaysShort": _propTypes.default.arrayOf(_propTypes.default.string)
    }),
    "positionedChildren": _propTypes.default.node,
    "prefix": _propTypes.default.string,
    "property": _propTypes.default.string,
    "radioGroup": _propTypes.default.string,
    "readOnly": _propTypes.default.bool,
    "rel": _propTypes.default.string,
    "required": _propTypes.default.bool,
    "resource": _propTypes.default.string,
    "results": _propTypes.default.number,
    "rev": _propTypes.default.string,
    "reverse": _propTypes.default.bool,
    "role": _propTypes.default.oneOfType([_propTypes.default.oneOf(["alert", "alertdialog", "application", "article", "banner", "button", "cell", "checkbox", "columnheader", "combobox", "complementary", "contentinfo", "definition", "dialog", "directory", "document", "feed", "figure", "form", "grid", "gridcell", "group", "heading", "img", "link", "list", "listbox", "listitem", "log", "main", "marquee", "math", "menu", "menubar", "menuitem", "menuitemcheckbox", "menuitemradio", "navigation", "none", "note", "option", "presentation", "progressbar", "radio", "radiogroup", "region", "row", "rowgroup", "rowheader", "scrollbar", "search", "searchbox", "separator", "slider", "spinbutton", "status", "switch", "tab", "table", "tablist", "tabpanel", "term", "textbox", "timer", "toolbar", "tooltip", "tree", "treegrid", "treeitem"]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "security": _propTypes.default.string,
    "size": _propTypes.default.oneOf(["large", "medium", "small"]),
    "slot": _propTypes.default.string,
    "spellCheck": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "src": _propTypes.default.string,
    "step": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "style": _propTypes.default.object,
    "suppressContentEditableWarning": _propTypes.default.bool,
    "suppressHydrationWarning": _propTypes.default.bool,
    "tabIndex": _propTypes.default.number,
    "title": _propTypes.default.string,
    "tooltipPosition": _propTypes.default.oneOf(["bottom", "left", "right", "top"]),
    "translate": _propTypes.default.oneOf(["no", "yes"]),
    "typeof": _propTypes.default.string,
    "unselectable": _propTypes.default.oneOf(["off", "on"]),
    "validationIconId": _propTypes.default.string,
    "validationOnLabel": _propTypes.default.bool,
    "value": _propTypes.default.string.isRequired,
    "vocab": _propTypes.default.string,
    "warning": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "width": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string])
  };
}
DateInput.displayName = "DateInput";
var _default = exports.default = DateInput;