"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Navbar = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _button = _interopRequireDefault(require("./button.style"));
var _navbar = _interopRequireDefault(require("./navbar.style"));
var _icon = _interopRequireDefault(require("../../../icon"));
var _events = _interopRequireDefault(require("../../../../__internal__/utils/helpers/events"));
var _useLocale = _interopRequireDefault(require("../../../../hooks/__internal__/useLocale"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const Navbar = ({
  onPreviousClick,
  onNextClick,
  className
}) => {
  const locale = (0, _useLocale.default)();
  const {
    previousMonthButton,
    nextMonthButton
  } = locale.date.ariaLabels;
  const handleKeyDown = ev => {
    if (_events.default.isLeftKey(ev) || _events.default.isRightKey(ev) || _events.default.isUpKey(ev) || _events.default.isDownKey(ev)) {
      ev.stopPropagation();
      ev.preventDefault();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_navbar.default, {
    className: className
  }, /*#__PURE__*/_react.default.createElement(_button.default, {
    "aria-label": previousMonthButton(),
    onClick: () => onPreviousClick?.(),
    onKeyDown: handleKeyDown
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "chevron_left"
  })), /*#__PURE__*/_react.default.createElement(_button.default, {
    "aria-label": nextMonthButton(),
    onClick: () => onNextClick?.(),
    onKeyDown: handleKeyDown
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "chevron_right"
  })));
};
exports.Navbar = Navbar;
var _default = exports.default = Navbar;