"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _addFocusStyling = _interopRequireDefault(require("../../../../style/utils/add-focus-styling"));
var _themes = require("../../../../style/themes");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const oldFocusStyling = `
  outline: solid 3px var(--colorsSemanticFocus500);
`;
const StyledButton = _styledComponents.default.button.attrs({
  type: "button"
})`
  justify-content: center;
  align-items: center;
  display: flex;
  border: var(--borderWidth200) solid var(--colorsActionMinorTransparent);
  background: none;
  box-shadow: none;
  cursor: pointer;
  height: var(--sizing500);
  width: var(--sizing500);
  padding: var(--spacing150);
  box-sizing: border-box;
  border-radius: var(--borderRadius050);

  ${({
  theme
}) => `
    &:focus {
      ${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}
    }
  `}
`;
StyledButton.defaultProps = {
  theme: _themes.baseTheme
};
var _default = exports.default = StyledButton;