"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DatePicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactDayPicker = _interopRequireDefault(require("react-day-picker"));
var _dom = require("@floating-ui/dom");
var _utils = require("../utils");
var _popover = _interopRequireDefault(require("../../../../__internal__/popover"));
var _useLocale = _interopRequireDefault(require("../../../../hooks/__internal__/useLocale"));
var _navbar = _interopRequireDefault(require("../navbar"));
var _weekday = _interopRequireDefault(require("../weekday"));
var _dayPicker = _interopRequireDefault(require("./day-picker.style"));
var _events = _interopRequireDefault(require("../../../../__internal__/utils/helpers/events"));
var _focusTrapUtils = require("../../../../__internal__/focus-trap/focus-trap-utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
/** there is an issue with typescript-to-proptypes package that means we need to override these types */

const popoverMiddleware = [(0, _dom.offset)(3), (0, _dom.flip)({
  fallbackStrategy: "initialPlacement"
})];
const DatePicker = ({
  inputElement,
  minDate,
  maxDate,
  selectedDays,
  disablePortal,
  onDayClick,
  pickerMouseDown,
  pickerProps,
  open,
  setOpen,
  pickerTabGuardId
}) => {
  const l = (0, _useLocale.default)();
  const {
    localize,
    options
  } = l.date.dateFnsLocale();
  const {
    weekStartsOn
  } = options || /* istanbul ignore next */{};
  const monthsLong = (0, _react.useMemo)(() => Array.from({
    length: 12
  }).map((_, i) => {
    const month = localize?.month(i);
    return month[0].toUpperCase() + month.slice(1);
  }), [localize]);
  const monthsShort = (0, _react.useMemo)(() => Array.from({
    length: 12
  }).map((_, i) => localize?.month(i, {
    width: "abbreviated"
  }).substring(0, 3)), [localize]);
  const weekdaysLong = (0, _react.useMemo)(() => Array.from({
    length: 7
  }).map((_, i) => localize?.day(i)), [localize]);
  const weekdaysShort = (0, _react.useMemo)(() => {
    const isGivenLocale = str => l.locale().includes(str);
    return Array.from({
      length: 7
    }).map((_, i) => localize?.day(i, ["de", "pl"].some(isGivenLocale) ? {
      width: "wide"
    } : {
      width: "abbreviated"
    }).substring(0, isGivenLocale("de") ? 2 : 3));
  }, [l, localize]);
  const ref = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (open) {
      // this is a temporary fix for some axe issues that are baked into the library we use for the picker
      const captionElement = ref.current?.querySelector(".DayPicker-Caption");
      /* istanbul ignore else */
      if (captionElement) {
        captionElement.removeAttribute("role");
        captionElement.removeAttribute("aria-live");
      }

      // focus the selected or today's date first
      const selectedDay = ref.current?.querySelector(".DayPicker-Day--selected") || ref.current?.querySelector(".DayPicker-Day--today");
      const firstDay = ref.current?.querySelector(".DayPicker-Day[tabindex='0']");

      /* istanbul ignore else */
      if (selectedDay && firstDay !== selectedDay) {
        selectedDay?.setAttribute("tabindex", "0");
        firstDay?.setAttribute("tabindex", "-1");
      }
    }
  }, [open]);
  const handleDayClick = (date, modifiers, ev) => {
    if (!modifiers.disabled) {
      const {
        id,
        name
      } = inputElement?.current?.firstChild;
      ev.target = {
        ...ev.target,
        id,
        name
      };
      onDayClick?.(date, ev);
    }
  };
  const handleKeyUp = (0, _react.useCallback)(ev => {
    /* istanbul ignore else */
    if (open && _events.default.isEscKey(ev)) {
      inputElement.current?.querySelector("input")?.focus();
      setOpen(false);
      ev.stopPropagation();
    }
  }, [inputElement, open, setOpen]);
  const handleOnKeyDown = ev => {
    /* istanbul ignore else */
    if (ref.current?.querySelector(".DayPicker-NavBar button") === document.activeElement && _events.default.isTabKey(ev) && _events.default.isShiftKey(ev)) {
      ev.preventDefault();
      setOpen(false);
      inputElement.current?.querySelector("input")?.focus();
    }
  };
  const handleOnDayKeyDown = (_day, _modifiers, ev) => {
    // we need to manually handle this as the picker may be in a Portal
    /* istanbul ignore else */
    if (_events.default.isTabKey(ev) && !_events.default.isShiftKey(ev)) {
      ev.preventDefault();
      setOpen(false);
      const input = inputElement.current?.querySelector("input");

      /* istanbul ignore else */
      if (input) {
        const elements = Array.from(document.querySelectorAll(_focusTrapUtils.defaultFocusableSelectors) || /* istanbul ignore next */[]);
        const elementsInPicker = Array.from(ref.current?.querySelectorAll("button, [tabindex]") || /* istanbul ignore next */[]);
        const filteredElements = elements.filter(el => Number(el.tabIndex) !== -1 && !elementsInPicker.includes(el));
        const nextIndex = filteredElements.indexOf(input) + 1;
        filteredElements[nextIndex]?.focus();
      }
    }
  };
  const formatDay = date => `${weekdaysShort[date.getDay()]} ${date.getDate()} ${monthsShort[date.getMonth()]} ${date.getFullYear()}`;
  if (!open) {
    return null;
  }
  const localeUtils = {
    formatDay
  };
  const handleTabGuardFocus = () => {
    ref.current?.querySelector("button")?.focus();
  };
  return /*#__PURE__*/_react.default.createElement(_popover.default, {
    placement: "bottom-start",
    reference: inputElement,
    middleware: popoverMiddleware,
    disablePortal: disablePortal
  }, /*#__PURE__*/_react.default.createElement(_dayPicker.default, {
    ref: ref,
    onMouseDown: pickerMouseDown,
    onKeyUp: handleKeyUp,
    onKeyDown: handleOnKeyDown
  }, /*#__PURE__*/_react.default.createElement("div", {
    id: pickerTabGuardId
    // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
    ,
    tabIndex: 0,
    onFocus: handleTabGuardFocus
  }), /*#__PURE__*/_react.default.createElement(_reactDayPicker.default, _extends({
    month: selectedDays,
    months: monthsLong,
    firstDayOfWeek: weekStartsOn,
    onDayClick: handleDayClick,
    selectedDays: selectedDays,
    weekdayElement: weekdayElementProps => {
      const {
        className,
        weekday
      } = weekdayElementProps;
      return /*#__PURE__*/_react.default.createElement(_weekday.default, {
        className: className,
        title: weekdaysLong[weekday]
      }, weekdaysShort[weekday]);
    },
    navbarElement: /*#__PURE__*/_react.default.createElement(_navbar.default, null),
    fixedWeeks: true,
    initialMonth: selectedDays || undefined,
    disabledDays: (0, _utils.getDisabledDays)(minDate, maxDate),
    locale: l.locale(),
    localeUtils: localeUtils,
    onDayKeyDown: handleOnDayKeyDown
  }, pickerProps))));
};
exports.DatePicker = DatePicker;
DatePicker.displayName = "DatePicker";
var _default = exports.default = DatePicker;