"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DateRange = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("../date/__internal__/utils");
var _date = _interopRequireDefault(require("../date"));
var _utils2 = require("../../style/utils");
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _dateRange = _interopRequireDefault(require("./date-range.style"));
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _usePrevious = _interopRequireDefault(require("../../hooks/__internal__/usePrevious"));
var _dateFormats = _interopRequireDefault(require("../date/__internal__/date-formats"));
var _dateRange2 = _interopRequireDefault(require("./date-range.context"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const DateRange = ({
  endDateProps = {},
  id,
  labelsInline,
  name,
  onBlur,
  onChange,
  startDateProps = {},
  tooltipPosition,
  validationOnLabel,
  value,
  startRef,
  endRef,
  required,
  isOptional,
  ...rest
}) => {
  const l = (0, _useLocale.default)();
  const {
    dateFnsLocale
  } = l.date;
  const {
    format
  } = (0, _react.useMemo)(() => (0, _dateFormats.default)(dateFnsLocale()), [dateFnsLocale]);
  const inlineLabelWidth = 40;
  const [lastChangedDate, setLastChangedDate] = (0, _react.useState)("");
  const computedValue = (0, _react.useCallback)(valueString => {
    if ((0, _utils.checkISOFormatAndLength)(valueString)) {
      return (0, _utils.formattedValue)(format, (0, _utils.parseISODate)(valueString));
    }
    return valueString;
  }, [format]);
  const getStartDate = (0, _react.useCallback)(() => {
    const {
      value: startValue
    } = startDateProps;
    return computedValue(startValue || value[0]);
  }, [startDateProps, value, computedValue]);
  const getEndDate = (0, _react.useCallback)(() => {
    const {
      value: endValue
    } = endDateProps;
    return computedValue(endValue || value[1]);
  }, [endDateProps, value, computedValue]);
  const [inputRefMap, setInputRefMap] = (0, _react.useState)({
    start: {
      isBlurBlocked: {
        current: false
      },
      setOpen: null
    },
    end: {
      isBlurBlocked: {
        current: false
      },
      setOpen: null
    }
  });
  function isEmptyValue(allowEmpty, inputValue) {
    return allowEmpty && !inputValue.length;
  }
  const [startDateValue, setStartDateValue] = (0, _react.useState)({
    formattedValue: getStartDate(),
    rawValue: isEmptyValue(!!startDateProps.allowEmptyValue, getStartDate()) ? "" : (0, _utils.formatToISO)(format, getStartDate())
  });
  const [endDateValue, setEndDateValue] = (0, _react.useState)({
    formattedValue: getEndDate(),
    rawValue: isEmptyValue(!!endDateProps.allowEmptyValue, getEndDate()) ? "" : (0, _utils.formatToISO)(format, getEndDate())
  });
  const previousValue = (0, _usePrevious.default)(value);
  (0, _react.useEffect)(() => {
    const updateValues = () => {
      setStartDateValue({
        formattedValue: getStartDate(),
        rawValue: isEmptyValue(!!startDateProps.allowEmptyValue, getStartDate()) ? "" : (0, _utils.formatToISO)(format, getStartDate())
      });
      setEndDateValue({
        formattedValue: getEndDate(),
        rawValue: isEmptyValue(!!endDateProps.allowEmptyValue, getEndDate()) ? "" : (0, _utils.formatToISO)(format, getEndDate())
      });
    };
    const hasPreviousValues = previousValue?.length;
    const hasUpdated = hasPreviousValues && (value[0] !== previousValue[0] || value[1] !== previousValue[1]);
    if (hasUpdated) {
      updateValues();
    }
  }, [value, previousValue, endDateProps.allowEmptyValue, format, getEndDate, getStartDate, startDateProps.allowEmptyValue]);
  const buildCustomEvent = (0, _react.useCallback)((changedDate, newValue) => {
    const startValue = changedDate === "start" ? newValue : startDateValue;
    const endValue = changedDate === "end" ? newValue : endDateValue;
    setLastChangedDate(changedDate);
    return {
      target: {
        ...(name && {
          name
        }),
        ...(id && {
          id
        }),
        value: [startValue, endValue]
      }
    };
  }, [endDateValue, id, name, startDateValue]);
  const handleOnChange = (changedDate, ev) => {
    if (changedDate === "start") {
      setStartDateValue({
        ...ev.target.value
      });
    } else {
      setEndDateValue({
        ...ev.target.value
      });
    }
    const event = buildCustomEvent(changedDate, ev.target.value);
    onChange(event);
  };
  const startDateOnChange = ev => {
    handleOnChange("start", ev);
  };
  const endDateOnChange = ev => {
    handleOnChange("end", ev);
  };
  const updateInputMap = newState => {
    setInputRefMap(prev => {
      return {
        ...prev,
        ...newState
      };
    });
  };
  const isBlurBlocked = () => inputRefMap?.start?.isBlurBlocked.current || inputRefMap?.end?.isBlurBlocked.current;
  const handleOnBlur = ev => {
    if (isBlurBlocked()) {
      return;
    }
    if (onBlur) {
      const event = buildCustomEvent(lastChangedDate, ev.target.value);
      onBlur(event);
    }
  };
  const closePicker = activeInput => {
    const refMap = inputRefMap?.[activeInput];

    /* istanbul ignore else */
    if (refMap) {
      refMap.setOpen?.(false);
      refMap.isBlurBlocked.current = false;
    }
  };
  const handleOnKeyDown = (ev, activeInput) => {
    if (_events.default.isTabKey(ev) && _events.default.isShiftKey(ev) && inputRefMap?.start) {
      inputRefMap.start.isBlurBlocked.current = !(activeInput === "start");
    } else if (_events.default.isTabKey(ev) && inputRefMap?.end) {
      inputRefMap.end.isBlurBlocked.current = !(activeInput === "end");
    }
  };
  const handleFocus = inputName => {
    closePicker(inputName);
    setLastChangedDate(inputName === "start" ? "end" : "start");
  };
  const dateProps = propsKey => {
    const props = propsKey === "start" ? startDateProps : endDateProps;
    const {
      formattedValue: inputValue
    } = propsKey === "start" ? startDateValue : endDateValue;
    const onChangeCallback = propsKey === "start" ? startDateOnChange : endDateOnChange;
    return {
      label: rest[`${propsKey}Label`],
      labelInline: labelsInline,
      value: inputValue,
      error: rest[`${propsKey}Error`],
      warning: rest[`${propsKey}Warning`],
      info: rest[`${propsKey}Info`],
      validationOnLabel,
      onBlur: handleOnBlur,
      onChange: onChangeCallback,
      onKeyDown: ev => handleOnKeyDown(ev, propsKey),
      ...props,
      required,
      isOptional
    };
  };
  return /*#__PURE__*/_react.default.createElement(_dateRange.default, _extends({}, (0, _tags.default)("date-range", rest), {
    labelsInline: labelsInline
  }, (0, _utils2.filterStyledSystemMarginProps)(rest)), /*#__PURE__*/_react.default.createElement(_dateRange2.default.Provider, {
    value: {
      inputRefMap,
      setInputRefMap: updateInputMap
    }
  }, /*#__PURE__*/_react.default.createElement(_date.default, _extends({
    my: 0 // prevents any form spacing being applied
  }, dateProps("start"), {
    onFocus: () => handleFocus("end"),
    "data-element": "start-date",
    inputName: "start",
    labelWidth: inlineLabelWidth // Textbox only applies this when labelsInLine prop is true
    ,
    tooltipPosition: tooltipPosition,
    ref: startRef
  })), /*#__PURE__*/_react.default.createElement(_date.default, _extends({
    my: 0 // prevents any form spacing being applied
  }, dateProps("end"), {
    onFocus: () => handleFocus("start"),
    "data-element": "end-date",
    inputName: "end",
    labelWidth: inlineLabelWidth // Textbox only applies this when labelsInLine prop is true
    ,
    tooltipPosition: tooltipPosition,
    ref: endRef
  }))));
};
exports.DateRange = DateRange;
DateRange.displayName = "DateRange";
var _default = exports.default = DateRange;