"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledContentTitle = exports.StyledContentBody = exports.StyledContent = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _themes = require("../../style/themes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledContent = exports.StyledContent = _styledComponents.default.div`
  ${({
  bodyFullWidth,
  align
}) => (0, _styledComponents.css)`
    ${_styledSystem.margin}

    & + & {
      margin-top: 15px;
    }

    ${align && (0, _styledComponents.css)`
      text-align: ${align};
    `}
    ${bodyFullWidth && (0, _styledComponents.css)`
      text-align: left;
    `}
  `}
`;
StyledContent.defaultProps = {
  theme: _themes.baseTheme
};
const StyledContentTitle = exports.StyledContentTitle = _styledComponents.default.div`
  ${({
  titleWidth,
  inline,
  variant,
  align
}) => {
  return (0, _styledComponents.css)`
      display: ${inline ? "inline-block" : "block"};
      font-weight: bold;
      width: ${titleWidth && `calc(${titleWidth}% - 30px)`};
      text-align: ${!inline && align};

      ${align === "center" && inline && (0, _styledComponents.css)`
        text-align: right;
        width: calc(50% - 30px);
      `}

      ${variant === "secondary" && (0, _styledComponents.css)`
        color: var(--colorsUtilityYin055);
        font-weight: normal;
      `}
    `;
}};
`;
const StyledContentBody = exports.StyledContentBody = _styledComponents.default.div`
  ${({
  bodyFullWidth,
  titleWidth,
  inline,
  align
}) => {
  return (0, _styledComponents.css)`
      display: ${inline ? "inline-block" : "block"};
      margin-top: 2px;
      white-space: pre-wrap;
      word-wrap: break-word;
      font-weight: normal;

      ${align === "center" && inline && (0, _styledComponents.css)`
        width: 50%;
      `}
      ${titleWidth && (0, _styledComponents.css)`
        width: ${100 - Number(titleWidth)}%;
      `}
      ${bodyFullWidth && (0, _styledComponents.css)`
        width: 100%;
      `}

      ${inline && bodyFullWidth && (0, _styledComponents.css)`
        margin-top: 15px;
      `}
      
      ${inline && !bodyFullWidth && (0, _styledComponents.css)`
        margin-top: 0;
        margin-left: 30px;
        text-align: left;
      `}
    `;
}};
`;