import { MarginProps } from "styled-system";
export declare type AlignOptions = "left" | "center" | "right";
export declare type VariantOptions = "primary" | "secondary";
export interface StyledContentProps extends MarginProps {
    /** Aligns the content (left, center or right) */
    align?: AlignOptions;
    /**
     * Over-rides the calculation of body width based on titleWidth.
     * Sometimes we need the body to be full width while keeping a title width similar to other widths
     */
    bodyFullWidth?: boolean;
}
declare const StyledContent: import("styled-components").StyledComponent<"div", any, StyledContentProps, never>;
export interface StyledContentTitleProps {
    /** Aligns the content (left, center or right) */
    align?: AlignOptions;
    /** Displays the content inline with the title */
    inline?: boolean;
    /** Sets a custom width for the title element */
    titleWidth?: string;
    /** Applies a theme to the Content Value: primary, secondary */
    variant?: VariantOptions;
}
declare const StyledContentTitle: import("styled-components").StyledComponent<"div", any, StyledContentTitleProps, never>;
export interface StyledContentBodyProps {
    /** Aligns the content (left, center or right) */
    align?: AlignOptions;
    /**
     * Over-rides the calculation of body width based on titleWidth.
     * Sometimes we need the body to be full width while keeping a title width similar to other widths
     */
    bodyFullWidth?: boolean;
    /** Displays the content inline with the title */
    inline?: boolean;
    /** Sets a custom width for the title element */
    titleWidth?: string;
    /** Applies a theme to the Content Value: primary, secondary */
    variant?: VariantOptions;
}
declare const StyledContentBody: import("styled-components").StyledComponent<"div", any, StyledContentBodyProps, never>;
export { StyledContent, StyledContentTitle, StyledContentBody };
