"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Content = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _content = require("./content.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Content = ({
  variant = "primary",
  children,
  title,
  inline = false,
  align = "left",
  titleWidth,
  bodyFullWidth = false,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(_content.StyledContent, _extends({
    align: align,
    bodyFullWidth: bodyFullWidth
  }, rest, {
    "data-component": "content"
  }), /*#__PURE__*/_react.default.createElement(_content.StyledContentTitle, {
    variant: variant,
    inline: inline,
    "data-element": "content-title",
    titleWidth: titleWidth,
    align: align
  }, title), /*#__PURE__*/_react.default.createElement(_content.StyledContentBody, {
    variant: variant,
    inline: inline,
    "data-element": "content-body",
    bodyFullWidth: bodyFullWidth,
    titleWidth: titleWidth,
    align: align
  }, children));
};
exports.Content = Content;
Content.displayName = "Content";
var _default = exports.default = Content;