"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Confirm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _heading = _interopRequireDefault(require("../heading"));
var _dialog = _interopRequireDefault(require("../dialog"));
var _confirm = require("./confirm.style");
var _button = _interopRequireDefault(require("../button/button.component"));
var _icon = _interopRequireDefault(require("../icon"));
var _loader = _interopRequireDefault(require("../loader"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Confirm = ({
  "aria-labelledby": ariaLabelledBy,
  "aria-describedby": ariaDescribedBy,
  "aria-label": ariaLabel,
  open,
  children,
  cancelButtonDestructive = false,
  confirmButtonDestructive = false,
  cancelButtonType = "secondary",
  confirmButtonType = "primary",
  cancelButtonIconType,
  cancelButtonIconPosition,
  confirmButtonIconType,
  confirmButtonIconPosition,
  cancelButtonDataProps,
  confirmButtonDataProps,
  cancelLabel,
  onCancel,
  disableCancel,
  onConfirm,
  isLoadingConfirm,
  disableConfirm,
  confirmLabel,
  iconType,
  subtitle,
  title,
  size = "extra-small",
  showCloseIcon = false,
  topModalOverride,
  ...rest
}) => {
  const l = (0, _useLocale.default)();
  const {
    current: titleId
  } = (0, _react.useRef)((0, _guid.default)());
  const {
    current: subtitleId
  } = (0, _react.useRef)((0, _guid.default)());
  const ariaProps = {
    "aria-labelledby": ariaLabelledBy,
    "aria-describedby": ariaDescribedBy,
    "aria-label": ariaLabel
  };
  if (title && iconType) {
    ariaProps["aria-labelledby"] = titleId;
  }
  if (subtitle && iconType) {
    ariaProps["aria-describedby"] = subtitleId;
  }
  const renderCancelButton = () => {
    if (!onCancel) return null;
    return /*#__PURE__*/_react.default.createElement(_button.default, _extends({
      onClick: onCancel,
      buttonType: cancelButtonType,
      destructive: cancelButtonDestructive,
      disabled: disableCancel,
      iconType: cancelButtonIconType,
      iconPosition: cancelButtonIconPosition
    }, (0, _tags.default)("cancel", {
      "data-element": "cancel",
      ...cancelButtonDataProps
    })), cancelLabel || l.confirm.no());
  };
  const renderConfirmButton = () => /*#__PURE__*/_react.default.createElement(_button.default, _extends({
    onClick: onConfirm,
    buttonType: confirmButtonType,
    destructive: confirmButtonDestructive,
    disabled: isLoadingConfirm || disableConfirm,
    ml: 2,
    iconType: confirmButtonIconType,
    iconPosition: confirmButtonIconPosition
  }, (0, _tags.default)("confirm", {
    "data-element": "confirm",
    ...confirmButtonDataProps
  })), isLoadingConfirm ? /*#__PURE__*/_react.default.createElement(_loader.default, {
    isInsideButton: true,
    isActive: true
  }) : confirmLabel || l.confirm.yes());
  const getTitle = () => {
    if (iconType) {
      return /*#__PURE__*/_react.default.createElement(_confirm.StyledConfirmHeading, {
        type: iconType,
        "data-element": iconType
      }, /*#__PURE__*/_react.default.createElement(_icon.default, {
        type: iconType,
        fontSize: "medium"
      }), /*#__PURE__*/_react.default.createElement(_heading.default, {
        title: title,
        titleId: titleId,
        subheader: subtitle,
        subtitleId: subtitleId,
        divider: false
      }));
    }
    return title;
  };
  return /*#__PURE__*/_react.default.createElement(_dialog.default, _extends({
    open: open,
    onCancel: onCancel,
    disableClose: disableCancel,
    subtitle: subtitle,
    title: getTitle(),
    "data-component": "confirm",
    role: "alertdialog",
    size: size,
    showCloseIcon: showCloseIcon,
    topModalOverride: topModalOverride
  }, ariaProps, rest), children, /*#__PURE__*/_react.default.createElement(_confirm.StyledConfirmButtons, null, renderCancelButton(), renderConfirmButton()));
};
exports.Confirm = Confirm;
var _default = exports.default = Confirm;